/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.plugin.core.osgi.GhidraBundle;

public class BundleStatus
implements Comparable<BundleStatus> {
    private final GhidraBundle.Type type;
    private final String location;
    private final ResourceFile file;
    private final boolean readOnly;
    private boolean enabled;
    private boolean active = false;
    private boolean busy = false;
    private String summary;

    BundleStatus(ResourceFile bundleFile, boolean enabled, boolean readOnly, String bundleLoc) {
        this.file = bundleFile;
        this.type = GhidraBundle.getType(this.getFile());
        this.location = bundleLoc;
        this.enabled = enabled;
        this.readOnly = readOnly;
    }

    @Override
    public int compareTo(BundleStatus o) {
        return this.getPathAsString().compareTo(o.getPathAsString());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public GhidraBundle.Type getType() {
        return this.type;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary != null ? this.summary : "";
    }

    public ResourceFile getFile() {
        return this.file;
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public String getPathAsString() {
        return Path.toPathString((ResourceFile)this.file);
    }

    public String getLocationIdentifier() {
        return this.location;
    }

    void setBusy(boolean isBusy) {
        this.busy = isBusy;
    }

    boolean isBusy() {
        return this.busy;
    }
}

