/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.scalartable.ScalarRowObject;
import ghidra.app.plugin.core.scalartable.ScalarSearchPlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Resource;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.SizeLimitedAccumulatorWrapper;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.FunctionNameTableColumn;
import ghidra.util.table.field.PreviewTableColumn;
import ghidra.util.table.field.ProgramLocationTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Font;
import java.math.BigInteger;
import java.util.Comparator;
import javax.swing.JLabel;

public class ScalarSearchModel
extends AddressBasedTableModel<ScalarRowObject> {
    static final int PREVIEW_COLUMN = 1;
    static final int HEX_COLUMN = 2;
    static final int TEMP_MAX_RESULTS = 1000000;
    private Listing listing;
    private ProgramSelection currentSelection;
    private long minValue;
    private long maxValue;
    private SizeLimitedAccumulatorWrapper<ScalarRowObject> sizedAccumulator;

    ScalarSearchModel(ScalarSearchPlugin plugin, ProgramSelection currentSelection) {
        super("Scalars", (ServiceProvider)plugin.getTool(), null, null);
        this.currentSelection = currentSelection;
    }

    @Override
    protected TableColumnDescriptor<ScalarRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new PreviewTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new ScalarHexUnsignedValueTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ScalarSignedDecimalValueTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ScalarUnsignedDecimalValueTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new ScalarFunctionNameTableColumn(this)));
        descriptor.addHiddenColumn((DynamicTableColumn)new ScalarBitCountTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new ScalarSignednessTableColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<ScalarRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.listing == null) {
            return;
        }
        this.sizedAccumulator = new SizeLimitedAccumulatorWrapper(accumulator, 1000000);
        if (this.currentSelection != null) {
            this.loadTableFromSelection(monitor);
            return;
        }
        monitor.initialize(this.listing.getNumCodeUnits());
        InstructionIterator instructions = this.listing.getInstructions(true);
        DataIterator dataIterator = this.listing.getDefinedData(true);
        this.iterateOverInstructions(monitor, instructions);
        this.iterateOverData(monitor, dataIterator);
        this.sizedAccumulator = null;
    }

    private boolean tooManyResults() {
        return this.sizedAccumulator.hasReachedSizeLimit();
    }

    void initialize(Program p, long newMinValue, long newMaxValue) {
        this.minValue = newMinValue;
        this.maxValue = newMaxValue;
        this.setProgram(p);
        this.listing = p.getListing();
        this.reload();
    }

    private void loadTableFromSelection(TaskMonitor monitor) throws CancelledException {
        BigInteger max = BigInteger.valueOf(0L);
        AddressRangeIterator ranges = this.currentSelection.getAddressRanges();
        for (AddressRange range : ranges) {
            max = max.add(range.getBigLength());
        }
        monitor.initialize(max.longValue());
        ranges = this.currentSelection.getAddressRanges();
        for (AddressRange range : ranges) {
            AddressSet addressSet = new AddressSet(range.getMinAddress(), range.getMaxAddress());
            InstructionIterator instructions = this.listing.getInstructions((AddressSetView)addressSet, true);
            this.iterateOverInstructions(monitor, instructions);
            DataIterator dataIterator = this.listing.getDefinedData((AddressSetView)addressSet, true);
            this.iterateOverData(monitor, dataIterator);
        }
    }

    private void iterateOverInstructions(TaskMonitor monitor, InstructionIterator instructions) throws CancelledException {
        for (Instruction instruction : instructions) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            if (this.tooManyResults()) {
                return;
            }
            int numOperands = instruction.getNumOperands();
            for (int opIndex = 0; opIndex <= numOperands; ++opIndex) {
                monitor.checkCancelled();
                Object[] opObjs = instruction.getOpObjects(opIndex);
                Reference[] operandReferences = instruction.getOperandReferences(opIndex);
                if (operandReferences.length != 0) continue;
                this.getScalarsFromInstruction(instruction, opObjs, monitor);
            }
        }
    }

    private void iterateOverData(TaskMonitor monitor, DataIterator dataIterator) throws CancelledException {
        while (dataIterator.hasNext()) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            if (this.tooManyResults()) {
                return;
            }
            Data data = dataIterator.next();
            int numComponents = data.getNumComponents();
            if (numComponents > 0) {
                this.findScalarsInCompositeData(data, numComponents, monitor);
                continue;
            }
            this.addScalarFromData(data);
        }
    }

    private void getScalarsFromInstruction(Instruction instruction, Object[] opObjs, TaskMonitor monitor) throws CancelledException {
        for (Object opObj : opObjs) {
            monitor.checkCancelled();
            Scalar scalar = this.getScalarFromOperand(opObj, monitor);
            if (scalar == null) continue;
            this.addMatch(new ScalarRowObject((CodeUnit)instruction, scalar));
        }
    }

    private void addMatch(ScalarRowObject rowObject) {
        long value;
        if (rowObject == null) {
            return;
        }
        Scalar scalar = rowObject.getScalar();
        long l = value = scalar.isSigned() ? scalar.getSignedValue() : scalar.getUnsignedValue();
        if (value < this.minValue || value > this.maxValue) {
            return;
        }
        this.sizedAccumulator.add((Object)rowObject);
    }

    private void findScalarsInCompositeData(Data data, int numComponents, TaskMonitor monitor) throws CancelledException {
        if (data.getDataType() instanceof Resource) {
            return;
        }
        for (int i = 0; i < numComponents; ++i) {
            monitor.checkCancelled();
            Data component = data.getComponent(i);
            this.getScalarsFromCompositeData(data, component, monitor);
        }
    }

    private void getScalarsFromCompositeData(Data data, Data component, TaskMonitor monitor) throws CancelledException {
        int numSubComponents = component.getNumComponents();
        if (numSubComponents == 0) {
            this.addDataFromComponent(data, component);
            return;
        }
        for (int i = 0; i < numSubComponents; ++i) {
            monitor.checkCancelled();
            Data subComponent = component.getComponent(i);
            this.getScalarsFromCompositeData(data, subComponent, monitor);
        }
    }

    private void addScalarFromData(Data data) {
        Scalar scalar = this.getScalarFromData(data);
        if (scalar == null) {
            return;
        }
        this.addMatch(new ScalarRowObject((CodeUnit)data, scalar));
    }

    private void addDataFromComponent(Data data, Data component) {
        Scalar scalar = this.getScalarFromData(component);
        if (scalar == null) {
            return;
        }
        this.addMatch(new ScalarRowObject((CodeUnit)component, scalar));
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            ScalarRowObject rowObject = (ScalarRowObject)this.getRowObject(element);
            CodeUnit cu = rowObject.getCodeUnit();
            set.addRange(cu.getMinAddress(), cu.getMaxAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    @Override
    public Address getAddress(int row) {
        ScalarRowObject rowObject = (ScalarRowObject)this.getRowObject(row);
        return rowObject.getAddress();
    }

    private Scalar getScalarFromOperand(Object opObj, TaskMonitor monitor) {
        return opObj instanceof Scalar ? (Scalar)opObj : null;
    }

    private Scalar getScalarFromData(Data data) {
        if (data == null) {
            return null;
        }
        if (!data.isDefined()) {
            return null;
        }
        Object value = data.getValue();
        if (!(value instanceof Scalar)) {
            return null;
        }
        return (Scalar)value;
    }

    private class ScalarHexUnsignedValueTableColumn
    extends AbstractScalarValueTableColumn {
        private static final int HEXADECIMAL_COL_WIDTH = 100;
        AbstractScalarValueRenderer renderer;

        private ScalarHexUnsignedValueTableColumn() {
            this.renderer = new AbstractScalarValueRenderer(){
                private static final int RADIX = 16;
                private static final boolean ZERO_PADDED = false;
                private static final boolean SHOW_SIGN = false;
                private static final String PREFIX = "0x";
                private static final String SUFFIX = "";

                @Override
                protected String formatScalar(Scalar scalar) {
                    if (scalar == null) {
                        return SUFFIX;
                    }
                    return scalar.toString(16, false, false, PREFIX, SUFFIX);
                }

                protected Font getDefaultFont() {
                    return this.fixedWidthFont;
                }

                @Override
                public GColumnRenderer.ColumnConstraintFilterMode getColumnConstraintFilterMode() {
                    return GColumnRenderer.ColumnConstraintFilterMode.ALLOW_ALL_FILTERS;
                }
            };
        }

        public String getColumnName() {
            return "Hex (Unsigned)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<Scalar> getColumnRenderer() {
            return this.renderer;
        }

        public Scalar getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Scalar scalar = rowObject.getScalar();
            return new Scalar(scalar.bitLength(), scalar.getUnsignedValue(), false);
        }
    }

    private class ScalarSignedDecimalValueTableColumn
    extends AbstractScalarValueTableColumn {
        private static final int DECIMAL_COL_WIDTH = 100;
        AbstractScalarValueRenderer renderer;

        private ScalarSignedDecimalValueTableColumn() {
            this.renderer = new AbstractScalarValueRenderer(){
                private static final int RADIX = 10;
                private static final boolean ZERO_PADDED = false;
                private static final boolean SHOW_SIGN = true;
                private static final String PREFIX = "";
                private static final String SUFFIX = "";

                @Override
                protected String formatScalar(Scalar scalar) {
                    if (scalar == null) {
                        return "";
                    }
                    return scalar.toString(10, false, true, "", "");
                }
            };
        }

        public String getColumnName() {
            return "Decimal (Signed)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<Scalar> getColumnRenderer() {
            return this.renderer;
        }

        public Scalar getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Scalar scalar = rowObject.getScalar();
            Scalar signed = new Scalar(scalar.bitLength(), scalar.getUnsignedValue(), true);
            return signed;
        }
    }

    private class ScalarUnsignedDecimalValueTableColumn
    extends AbstractScalarValueTableColumn {
        private static final int DECIMAL_COL_WIDTH = 100;
        AbstractScalarValueRenderer renderer;

        private ScalarUnsignedDecimalValueTableColumn() {
            this.renderer = new AbstractScalarValueRenderer(){
                private static final int RADIX = 10;
                private static final boolean ZERO_PADDED = false;
                private static final boolean SHOW_SIGN = false;
                private static final String PREFIX = "";
                private static final String SUFFIX = "";

                @Override
                protected String formatScalar(Scalar scalar) {
                    if (scalar == null) {
                        return "";
                    }
                    return scalar.toString(10, false, false, "", "");
                }
            };
        }

        public String getColumnName() {
            return "Decimal (Unsigned)";
        }

        public int getColumnPreferredWidth() {
            return 100;
        }

        public GColumnRenderer<Scalar> getColumnRenderer() {
            return this.renderer;
        }

        public Scalar getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            Scalar scalar = rowObject.getScalar();
            Scalar unsigned = new Scalar(scalar.bitLength(), scalar.getUnsignedValue(), false);
            return unsigned;
        }
    }

    private class ScalarFunctionNameTableColumn
    extends FunctionNameTableColumn {
        private static final int FUNCTION_COL_WIDTH = 150;

        private ScalarFunctionNameTableColumn(ScalarSearchModel scalarSearchModel) {
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private class ScalarBitCountTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Integer, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Integer> {
        private static final int BIT_COUNT_COL_WIDTH = 80;

        private ScalarBitCountTableColumn() {
        }

        public String getColumnName() {
            return "Bits";
        }

        public Integer getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return rowObject.getScalar().bitLength();
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(ScalarSearchModel.this.program, rowObject.getAddress());
        }

        public int getColumnPreferredWidth() {
            return 80;
        }
    }

    private class ScalarSignednessTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Signedness, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Signedness> {
        private static final int SIGNEDNESS_COL_WIDTH = 100;

        private ScalarSignednessTableColumn() {
        }

        public String getColumnName() {
            return "Signedness";
        }

        public Signedness getValue(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) throws IllegalArgumentException {
            return rowObject.getScalar().isSigned() ? Signedness.Signed : Signedness.Unsigned;
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(ScalarSearchModel.this.program, rowObject.getAddress());
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    public static enum Signedness {
        Signed,
        Unsigned;

    }

    private abstract class AbstractScalarValueTableColumn
    extends AbstractDynamicTableColumn<ScalarRowObject, Scalar, Program>
    implements ProgramLocationTableColumn<ScalarRowObject, Scalar> {
        private AbstractScalarValueTableColumn() {
        }

        public Comparator<Scalar> getComparator() {
            return new ScalarComparator(ScalarSearchModel.this);
        }

        @Override
        public ProgramLocation getProgramLocation(ScalarRowObject rowObject, Settings settings, Program p, ServiceProvider provider) {
            return new ProgramLocation(p, rowObject.getAddress());
        }
    }

    private abstract class AbstractScalarValueRenderer
    extends AbstractGColumnRenderer<Scalar> {
        private AbstractScalarValueRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            Scalar value = (Scalar)data.getValue();
            String text = this.formatScalar(value);
            label.setText(text);
            label.setOpaque(true);
            this.setHorizontalAlignment(4);
            return label;
        }

        protected abstract String formatScalar(Scalar var1);

        public GColumnRenderer.ColumnConstraintFilterMode getColumnConstraintFilterMode() {
            return GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY;
        }

        public String getFilterString(Scalar t, Settings settings) {
            return this.formatScalar(t);
        }
    }

    private class ScalarComparator
    implements Comparator<Scalar> {
        private ScalarComparator(ScalarSearchModel scalarSearchModel) {
        }

        @Override
        public int compare(Scalar o1, Scalar o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.isSigned() != o2.isSigned()) {
                return o1.isSigned() ? 1 : -1;
            }
            return o1.isSigned() ? Long.compare(o1.getSignedValue(), o2.getSignedValue()) : Long.compareUnsigned(o1.getUnsignedValue(), o2.getUnsignedValue());
        }
    }
}

