/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.dnd.GenericDataFlavor;
import ghidra.app.util.CodeUnitInfo;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class CodeUnitInfoTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localDataTypeFlavor = CodeUnitInfoTransferable.createLocalDataTypeFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localDataTypeFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private List<CodeUnitInfo> infoList;

    private static DataFlavor createLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=java.util.ArrayList", "Local code unit info object");
        }
        catch (Exception e) {
            Msg.showError(CodeUnitInfoTransferable.class, null, (String)"Could Not Create Data Flavor", (Object)"Unexpected exception creating data flavor for code unit info", (Throwable)e);
            return null;
        }
    }

    public CodeUnitInfoTransferable(List<CodeUnitInfo> list) {
        this.infoList = list;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localDataTypeFlavor)) {
            return this.infoList;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "CodeUnitInfoTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

