/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public record GoModuleInfo(String path, String version, String sum, GoModuleInfo replace) {
    public static GoModuleInfo fromString(String s, GoModuleInfo replace) throws IOException {
        String[] parts = s.split("\t");
        if (parts.length != 2 && parts.length != 3) {
            throw new IOException();
        }
        return new GoModuleInfo(parts[0], parts[1], parts.length == 3 ? parts[2] : null, replace);
    }

    public String getFormattedString() {
        return this.replace == null ? "%s %s %s".formatted(this.path, this.version, this.sum != null ? this.sum : "") : "%s %s => %s".formatted(this.path, this.version, this.replace.getFormattedString());
    }

    public Map<String, String> asKeyValuePairs(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(prefix + "path", Objects.requireNonNullElse(this.path, "-missing-"));
        result.put(prefix + "version", Objects.requireNonNullElse(this.version, "-missing-"));
        if (this.sum != null) {
            result.put(prefix + "sum", this.sum);
        }
        if (this.replace != null) {
            result.put(prefix + "replace", this.replace.getFormattedString());
        }
        return result;
    }
}

