/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import java.io.Serializable;

public class RepositoryChangeEvent
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int REP_NULL_EVENT = -1;
    public static final int REP_FOLDER_CREATED = 0;
    public static final int REP_ITEM_CREATED = 1;
    public static final int REP_FOLDER_DELETED = 2;
    public static final int REP_FOLDER_MOVED = 3;
    public static final int REP_FOLDER_RENAMED = 4;
    public static final int REP_ITEM_DELETED = 5;
    public static final int REP_ITEM_RENAMED = 6;
    public static final int REP_ITEM_MOVED = 7;
    public static final int REP_ITEM_CHANGED = 8;
    public static final int REP_OPEN_HANDLE_COUNT = 9;
    private static final int LAST_TYPE = 9;
    private static final String[] TYPES = new String[]{"Folder Created", "Item Created", "Folder Deleted", "Folder Moved", "Folder Renamed", "Item Deleted", "Item Renamed", "Item Moved", "Item Changed", "Open Handle Cnt"};
    public final int type;
    public final String parentPath;
    public final String name;
    public final String newParentPath;
    public final String newName;

    public RepositoryChangeEvent(int type, String parentPath, String name, String newParentPath, String newName) {
        this.type = type;
        this.parentPath = parentPath;
        this.name = name;
        this.newParentPath = newParentPath;
        this.newName = newName;
    }

    public String toString() {
        if (this.type >= 0 && this.type <= 9) {
            StringBuffer buf = new StringBuffer();
            buf.append("<");
            buf.append(TYPES[this.type]);
            buf.append(",parentPath=");
            buf.append(this.parentPath);
            buf.append(",name=");
            buf.append(this.name);
            buf.append(",newParentPath=");
            buf.append(this.newParentPath);
            buf.append(",newName=");
            buf.append(this.newName);
            buf.append(">");
            return buf.toString();
        }
        if (this.type == -1) {
            return "<Null Event>";
        }
        return "<Unknown RepositoryChangeEvent>";
    }
}

