/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValueMapSymbol
extends ValueSymbol {
    private long[] valuetable;
    private boolean tableisfilled;

    public List<Long> getMap() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (long v : this.valuetable) {
            result.add(v);
        }
        return Collections.unmodifiableList(result);
    }

    private void checkTableFill() {
        long min = this.getPatternValue().minValue();
        long max = this.getPatternValue().maxValue();
        this.tableisfilled = min >= 0L && max < (long)this.valuetable.length;
        for (long element : this.valuetable) {
            if (element != 195935983L) continue;
            this.tableisfilled = false;
        }
    }

    @Override
    public Constructor resolve(ParserWalker walker, SleighDebugLogger debug) throws MemoryAccessException, UnknownInstructionException {
        long ind;
        if (!(this.tableisfilled || (ind = this.getPatternValue().getValue(walker)) < (long)this.valuetable.length && ind >= 0L && this.valuetable[(int)ind] != 195935983L)) {
            String errmsg = "No corresponding entry in valuetable <" + this.getName() + ">, index=" + ind;
            if (debug != null) {
                debug.append(errmsg + "\n");
            }
            throw new UnknownInstructionException(errmsg);
        }
        return null;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        hand.space = walker.getConstSpace();
        hand.offset_space = null;
        hand.offset_offset = this.valuetable[ind];
        hand.size = 0;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        int ind = (int)this.getPatternValue().getValue(walker);
        long val = this.valuetable[ind];
        String res = val >= 0L ? "0x" + Long.toHexString(val) : "-0x" + Long.toHexString(-val);
        return res;
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        this.patval = (PatternValue)PatternExpression.decodeExpression(decoder, sleigh);
        ArrayList<Long> values = new ArrayList<Long>();
        while (decoder.peekElement() == SlaFormat.ELEM_VALUETAB.id()) {
            decoder.openElement();
            values.add(decoder.readSignedInteger(SlaFormat.ATTRIB_VAL));
            decoder.closeElement(SlaFormat.ELEM_VALUETAB.id());
        }
        this.valuetable = new long[values.size()];
        for (int i = 0; i < this.valuetable.length; ++i) {
            this.valuetable[i] = (Long)values.get(i);
        }
        this.checkTableFill();
        decoder.closeElement(SlaFormat.ELEM_VALUEMAP_SYM.id());
    }
}

