/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slgh_compile;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.semantics.OpTpl;
import ghidra.pcodeCPort.semantics.PcodeBuilder;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.slgh_compile.SleighCompile;
import ghidra.sleigh.grammar.Location;

public class MacroBuilder
extends PcodeBuilder {
    private SleighCompile slgh;
    private Location location;
    private boolean haserror = false;
    private VectorSTL<OpTpl> outvec = null;
    private VectorSTL<HandleTpl> params = new VectorSTL();

    public MacroBuilder(SleighCompile sl, Location loc, VectorSTL<OpTpl> ovec, int lbcnt) {
        super(lbcnt);
        this.slgh = sl;
        this.location = loc;
        this.outvec = ovec;
    }

    public boolean hasError() {
        return this.haserror;
    }

    @Override
    public void appendBuild(OpTpl bld, int secnum) {
        this.dump(bld);
    }

    @Override
    public void appendCrossBuild(OpTpl bld, int secnum) {
        this.dump(bld);
    }

    @Override
    public void delaySlot(OpTpl op) {
        this.dump(op);
    }

    private void free() {
        IteratorSTL iter = this.params.begin();
        while (!iter.isEnd()) {
            ((HandleTpl)iter.get()).dispose();
            iter.increment();
        }
        this.params.clear();
    }

    public void setMacroOp(OpTpl macroop) {
        this.free();
        for (int i = 1; i < macroop.numInput(); ++i) {
            VarnodeTpl vn = macroop.getIn(i);
            HandleTpl hand = new HandleTpl(vn);
            this.params.push_back((Object)hand);
        }
    }

    @Override
    public void dump(OpTpl op) {
        OpTpl clone = new OpTpl(op.location, op.getOpcode());
        VarnodeTpl vn = op.getOut();
        if (vn != null) {
            VarnodeTpl v_clone = new VarnodeTpl(null, vn);
            clone.setOutput(v_clone);
        }
        for (int i = 0; i < op.numInput(); ++i) {
            vn = op.getIn(i);
            VarnodeTpl v_clone = new VarnodeTpl(null, vn);
            if (v_clone.isRelative()) {
                long val = v_clone.getOffset().getReal() + (long)this.getLabelBase();
                v_clone.setRelative(val);
            }
            clone.addInput(v_clone);
        }
        if (!this.transferOp(clone, this.params)) {
            clone.dispose();
        }
    }

    @Override
    public void setLabel(OpTpl op) {
        OpTpl clone = new OpTpl(op.location, op.getOpcode());
        VarnodeTpl v_clone = new VarnodeTpl(null, op.getIn(0));
        long val = v_clone.getOffset().getReal() + (long)this.getLabelBase();
        v_clone.setOffset(val);
        clone.addInput(v_clone);
        this.outvec.push_back((Object)clone);
    }

    private void reportError(String val) {
        this.slgh.reportError(this.location, val);
        this.haserror = true;
    }

    private boolean transferOp(OpTpl op, VectorSTL<HandleTpl> params) {
        int plus;
        VarnodeTpl outvn = op.getOut();
        int handleIndex = 0;
        boolean hasrealsize = false;
        long realsize = 0L;
        if (outvn != null && (plus = outvn.transfer(params)) >= 0) {
            this.reportError("Cannot currently assign to bitrange of macro parameter that is a temporary");
            return false;
        }
        for (int i = 0; i < op.numInput(); ++i) {
            VarnodeTpl vn = op.getIn(i);
            if (vn.getOffset().getType() == ConstTpl.const_type.handle) {
                handleIndex = vn.getOffset().getHandleIndex();
                hasrealsize = vn.getSize().getType() == ConstTpl.const_type.real;
                realsize = vn.getSize().getReal();
            }
            if ((plus = vn.transfer(params)) < 0) continue;
            if (!hasrealsize) {
                this.reportError("Problem with bit range operator in macro");
                return false;
            }
            long newtemp = this.slgh.getUniqueAddr();
            OpTpl subpieceop = new OpTpl(this.location, OpCode.CPUI_SUBPIECE);
            VarnodeTpl newvn = new VarnodeTpl(this.location, new ConstTpl(this.slgh.getUniqueSpace()), new ConstTpl(ConstTpl.const_type.real, newtemp), new ConstTpl(ConstTpl.const_type.real, realsize));
            subpieceop.setOutput(newvn);
            HandleTpl hand = (HandleTpl)params.get(handleIndex);
            VarnodeTpl origvn = new VarnodeTpl(this.location, hand.getSpace(), hand.getPtrOffset(), hand.getSize());
            subpieceop.addInput(origvn);
            VarnodeTpl plusvn = new VarnodeTpl(this.location, new ConstTpl(this.slgh.getConstantSpace()), new ConstTpl(ConstTpl.const_type.real, plus), new ConstTpl(ConstTpl.const_type.real, 4L));
            subpieceop.addInput(plusvn);
            this.outvec.push_back((Object)subpieceop);
            vn.dispose();
            op.setInput(new VarnodeTpl(this.location, newvn), i);
        }
        this.outvec.push_back((Object)op);
        return true;
    }
}

