/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.MultEntSubModel;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

class MultEntSubIterator
implements CodeBlockIterator {
    private Listing listing = null;
    private CodeBlock nextSub = null;
    private AddressSet addrSet = null;
    private MultEntSubModel model = null;
    private TaskMonitor monitor;

    MultEntSubIterator(MultEntSubModel model, TaskMonitor monitor) {
        this.model = model;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.listing = model.getProgram().getListing();
        this.addrSet = new AddressSet(model.getProgram().getMemory());
        this.nextSub = null;
    }

    MultEntSubIterator(MultEntSubModel model, AddressSetView set, TaskMonitor monitor) {
        this.model = model;
        this.monitor = monitor;
        monitor.setIndeterminate(true);
        this.listing = model.getProgram().getListing();
        this.addrSet = new AddressSet(set);
        this.nextSub = null;
    }

    @Override
    public boolean hasNext() throws CancelledException {
        if (this.nextSub != null) {
            return true;
        }
        Address addr = this.addrSet.getMinAddress();
        if (addr == null) {
            return false;
        }
        if (addr.isExternalAddress()) {
            this.nextSub = this.model.getCodeBlockAt(addr, this.monitor);
            this.addrSet.deleteRange(addr, addr);
            return true;
        }
        Instruction instr = this.listing.getInstructionAt(addr);
        if (instr == null) {
            this.addrSet.deleteRange(addr, addr);
        }
        while (instr == null) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                throw new CancelledException();
            }
            instr = this.listing.getInstructionAfter(addr);
            if (instr == null) {
                this.addrSet.clear();
                return false;
            }
            Address minAddr = instr.getMinAddress();
            boolean setHadMinAddr = this.addrSet.contains(minAddr);
            this.addrSet.deleteRange(addr, minAddr);
            if (setHadMinAddr) {
                this.addrSet.addRange(minAddr, minAddr);
            }
            if (this.addrSet.contains(addr = minAddr)) continue;
            instr = null;
            addr = this.addrSet.getMinAddress();
            if (addr != null) continue;
            return false;
        }
        this.nextSub = this.model.getFirstCodeBlockContaining(addr, this.monitor);
        this.addrSet.delete(this.nextSub);
        return true;
    }

    @Override
    public CodeBlock next() throws CancelledException {
        if (this.nextSub == null) {
            this.hasNext();
        }
        CodeBlock retSub = this.nextSub;
        this.nextSub = null;
        return retSub;
    }
}

