/**
 * Parse a comment marker.
 *
 * @param {unknown} value
 *   Thing to parse, typically `Node`.
 * @returns {Marker | null}
 *   Info when applicable or `null`.
 */
export function commentMarker(value: unknown): Marker | null
export type Root = import('mdast').Root
export type Content = import('mdast').Content
export type HTML = import('mdast').HTML
export type MDXFlowExpression =
  import('mdast-util-mdx-expression').MDXFlowExpression
export type MDXTextExpression =
  import('mdast-util-mdx-expression').MDXTextExpression
export type Node = Root | Content
export type Mdx1CommentNode = {
  type: 'comment'
  value: string
}
/**
 * Value.
 *
 * If it looks like a number (to JavaScript), it’s cast as number.
 * The strings `true` and `false` are turned into their corresponding
 * booleans.
 * The empty string is also considered the `true` boolean.
 */
export type MarkerParameterValue = string | number | boolean
/**
 * Parameters.
 */
export type MarkerParameters = Record<string, MarkerParameterValue>
/**
 * Comment marker.
 */
export type Marker = {
  /**
   * Name of marker.
   */
  name: string
  /**
   * Value after name.
   */
  attributes: string
  /**
   * Parsed attributes.
   */
  parameters: MarkerParameters
  /**
   * Reference to given node.
   */
  node: HTML | Mdx1CommentNode | MDXFlowExpression | MDXTextExpression
}
