/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Comment;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.TokenStream;

public class Node
implements Cloneable {
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int SOURCE_PROP = 17;
    public static final int TYPE_PROP = 18;
    public static final int SPECIAL_PROP_PROP = 19;
    public static final int LABEL_PROP = 20;
    public static final int FINALLY_PROP = 21;
    public static final int LOCALCOUNT_PROP = 22;
    public static final int TARGETBLOCK_PROP = 23;
    public static final int VARIABLE_PROP = 24;
    public static final int LASTUSE_PROP = 25;
    public static final int ISNUMBER_PROP = 26;
    public static final int DIRECTCALL_PROP = 27;
    public static final int BASE_LINENO_PROP = 28;
    public static final int END_LINENO_PROP = 29;
    public static final int SPECIALCALL_PROP = 30;
    public static final int DEBUGSOURCE_PROP = 31;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    int type;
    Node next;
    private Node first;
    private Node last;
    private CodePosition position;
    private Comment commentBefore;
    private Comment commentAfter;
    private int operation;

    public Node(int nodeType) {
        this.type = nodeType;
    }

    public Node(int nodeType, Node child, CodePosition position) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
        this.position = position;
    }

    public Node(int nodeType, Node child, int operation, CodePosition position) {
        this.type = nodeType;
        this.first = this.last = child;
        child.next = null;
        this.operation = operation;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node right, CodePosition position) {
        this(nodeType, left, right, -1, position);
    }

    public Node(int nodeType, Node left, Node right, int operation, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = right;
        right.next = null;
        this.operation = operation;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node mid, Node right, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = right;
        right.next = null;
        this.position = position;
    }

    public Node(int nodeType, Node left, Node mid, Node mid2, Node right, CodePosition position) {
        this.type = nodeType;
        this.first = left;
        this.last = right;
        left.next = mid;
        mid.next = mid2;
        mid2.next = right;
        right.next = null;
        this.position = position;
    }

    public Node(int nodeType, Node[] children) {
        this.type = nodeType;
        if (children.length != 0) {
            this.first = children[0];
            this.last = children[children.length - 1];
            for (int i = 1; i < children.length; ++i) {
                if (null != children[i - 1].next) {
                    throw new IllegalArgumentException("duplicate child");
                }
                children[i - 1].next = children[i];
            }
            if (null != this.last.next) {
                throw new IllegalArgumentException("duplicate child");
            }
        }
    }

    public Node(int nodeType, CodePosition position) {
        this.type = nodeType;
        this.position = position;
    }

    public Node(int nodeType, int operation, CodePosition position) {
        this.type = nodeType;
        this.operation = operation;
        this.position = position;
    }

    public static Node newIntNumber(double number, CodePosition position) {
        return new NumberNode(148, number, position);
    }

    public static Node newNumber(double number, CodePosition position) {
        return new NumberNode(45, number, position);
    }

    public static Node newString(String str, CodePosition position) {
        return new StringNode(46, str, position);
    }

    public static Node newString(int type, String str, CodePosition position) {
        return new StringNode(type, str, position);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public int getChildCount() {
        int c = 0;
        Node n = this.first;
        while (n != null) {
            ++c;
            n = n.next;
        }
        return c;
    }

    public Node getLastSibling() {
        Node n = this;
        while (n.next != null) {
            n = n.next;
        }
        return n;
    }

    public void addChildToBack(Node child) {
        child.next = null;
        if (this.last == null) {
            this.first = this.last = child;
            return;
        }
        this.last.next = child;
        this.last = child;
    }

    public void addChildrenToBack(Node children) {
        if (this.last != null) {
            this.last.next = children;
        }
        this.last = children.getLastSibling();
        if (this.first == null) {
            this.first = children;
        }
    }

    public Comment getCommentsBeforeNode() {
        return this.commentBefore;
    }

    public Comment getCommentsAfterNode() {
        return this.commentAfter;
    }

    public void setCommentsBeforeNode(Comment comment) {
        if (comment == null) {
            return;
        }
        this.commentBefore = comment;
    }

    public void setCommentsAfterNode(Comment comment) {
        if (comment == null) {
            return;
        }
        this.commentAfter = comment;
    }

    private static final String propToString(int propType) {
        switch (propType) {
            case 1: {
                return "target";
            }
            case 2: {
                return "break";
            }
            case 3: {
                return "continue";
            }
            case 4: {
                return "enum";
            }
            case 5: {
                return "function";
            }
            case 6: {
                return "temp";
            }
            case 7: {
                return "local";
            }
            case 8: {
                return "codeoffset";
            }
            case 9: {
                return "fixups";
            }
            case 10: {
                return "vars";
            }
            case 11: {
                return "uses";
            }
            case 12: {
                return "regexp";
            }
            case 13: {
                return "cases";
            }
            case 14: {
                return "default";
            }
            case 15: {
                return "casearray";
            }
            case 16: {
                return "sourcename";
            }
            case 17: {
                return "source";
            }
            case 18: {
                return "type";
            }
            case 19: {
                return "special_prop";
            }
            case 20: {
                return "label";
            }
            case 21: {
                return "finally";
            }
            case 22: {
                return "localcount";
            }
            case 23: {
                return "targetblock";
            }
            case 24: {
                return "variable";
            }
            case 25: {
                return "lastuse";
            }
            case 26: {
                return "isnumber";
            }
            case 27: {
                return "directcall";
            }
            case 28: {
                return "base_lineno";
            }
            case 29: {
                return "end_lineno";
            }
            case 30: {
                return "specialcall";
            }
            case 31: {
                return "debugsource";
            }
        }
        Context.codeBug();
        return null;
    }

    public int getOperation() {
        return this.operation;
    }

    public CodePosition getPosition() {
        return this.position;
    }

    public void setPosition(CodePosition position) {
        this.position = position;
    }

    public double getDouble() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public String getString() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String s) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(TokenStream.tokenToName(this.type));
        if (this instanceof StringNode) {
            sb.append(' ');
            sb.append(this.getString());
        } else {
            switch (this.type) {
                case 137: {
                    sb.append(' ');
                    sb.append(this.hashCode());
                    break;
                }
                case 148: {
                    sb.append(' ');
                    sb.append((int)this.getDouble());
                    break;
                }
                case 45: {
                    sb.append(' ');
                    sb.append(this.getDouble());
                    break;
                }
                case 110: {
                    sb.append(' ');
                    sb.append(this.first.getString());
                }
            }
        }
        if (this.operation != -1) {
            sb.append(' ');
            sb.append(this.operation);
        }
        return sb.toString();
    }

    private static class StringNode
    extends Node {
        private String str;

        StringNode(int type, String str, CodePosition position) {
            super(type, position);
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String str) {
            if (null == str) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = str;
        }
    }

    private static class NumberNode
    extends Node {
        private double number;

        NumberNode(int type, double number, CodePosition position) {
            super(type, position);
            this.number = number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }
    }
}

