/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.runtime.isolation.LoaderSwap;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class TransformationStage<R extends ConnectRecord<R>>
implements AutoCloseable {
    static final String PREDICATE_CONFIG = "predicate";
    static final String NEGATE_CONFIG = "negate";
    private final Plugin<Predicate<R>> predicatePlugin;
    private final Plugin<Transformation<R>> transformationPlugin;
    private final boolean negate;
    private final String transformAlias;
    private final String predicateAlias;
    private final String transformVersion;
    private final String predicateVersion;
    private final Function<ClassLoader, LoaderSwap> pluginLoaderSwapper;

    TransformationStage(Plugin<Transformation<R>> transformationPlugin, String transformAlias, String transformVersion, Function<ClassLoader, LoaderSwap> pluginLoaderSwapper) {
        this(null, null, null, false, transformationPlugin, transformAlias, transformVersion, pluginLoaderSwapper);
    }

    TransformationStage(Plugin<Predicate<R>> predicatePlugin, String predicateAlias, String predicateVersion, boolean negate, Plugin<Transformation<R>> transformationPlugin, String transformAlias, String transformVersion, Function<ClassLoader, LoaderSwap> pluginLoaderSwapper) {
        this.predicatePlugin = predicatePlugin;
        this.negate = negate;
        this.transformationPlugin = transformationPlugin;
        this.pluginLoaderSwapper = pluginLoaderSwapper;
        this.transformAlias = transformAlias;
        this.predicateAlias = predicateAlias;
        this.transformVersion = transformVersion;
        this.predicateVersion = predicateVersion;
    }

    public Class<? extends Transformation<R>> transformClass() {
        Class<?> transformClass = ((Transformation)this.transformationPlugin.get()).getClass();
        return transformClass;
    }

    public R apply(R record) {
        LoaderSwap swap;
        boolean shouldTransform;
        Predicate predicate = this.predicatePlugin != null ? (Predicate)this.predicatePlugin.get() : null;
        boolean bl = shouldTransform = predicate == null;
        if (predicate != null) {
            swap = this.pluginLoaderSwapper.apply(predicate.getClass().getClassLoader());
            try {
                shouldTransform = this.negate ^ predicate.test(record);
            }
            finally {
                if (swap != null) {
                    swap.close();
                }
            }
        }
        if (shouldTransform) {
            swap = this.pluginLoaderSwapper.apply(((Transformation)this.transformationPlugin.get()).getClass().getClassLoader());
            try {
                record = ((Transformation)this.transformationPlugin.get()).apply(record);
            }
            finally {
                if (swap != null) {
                    swap.close();
                }
            }
        }
        return record;
    }

    @Override
    public void close() {
        Utils.closeQuietly(this.transformationPlugin, (String)"transformation");
        Utils.closeQuietly(this.predicatePlugin, (String)PREDICATE_CONFIG);
    }

    public String toString() {
        return "TransformationStage{predicate=" + String.valueOf(this.predicatePlugin.get()) + ", transformation=" + String.valueOf(this.transformationPlugin.get()) + ", negate=" + this.negate + "}";
    }

    public StageInfo transformationStageInfo() {
        AliasedPluginInfo transformInfo = new AliasedPluginInfo(this.transformAlias, ((Transformation)this.transformationPlugin.get()).getClass().getName(), this.transformVersion);
        AliasedPluginInfo predicateInfo = this.predicatePlugin != null ? new AliasedPluginInfo(this.predicateAlias, ((Predicate)this.predicatePlugin.get()).getClass().getName(), this.predicateVersion) : null;
        return new StageInfo(transformInfo, predicateInfo);
    }

    public record AliasedPluginInfo(String alias, String className, String version) {
        public AliasedPluginInfo {
            Objects.requireNonNull(alias, "alias cannot be null");
            Objects.requireNonNull(className, "className cannot be null");
        }
    }

    public record StageInfo(AliasedPluginInfo transform, AliasedPluginInfo predicate) {
        public StageInfo {
            Objects.requireNonNull(transform, "transform cannot be null");
        }
    }
}

