/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.kafka.server.share.persister.PersisterStateBatch;

public class PersisterStateBatchCombiner {
    private List<PersisterStateBatch> combinedBatchList;
    private final long startOffset;
    private TreeSet<PersisterStateBatch> sortedBatches;
    private List<PersisterStateBatch> finalBatchList;

    public PersisterStateBatchCombiner(List<PersisterStateBatch> batchesSoFar, List<PersisterStateBatch> newBatches, long startOffset) {
        this.initializeCombinedList(batchesSoFar, newBatches);
        int estimatedResultSize = this.combinedBatchList.size() * 3 / 2;
        this.finalBatchList = new ArrayList<PersisterStateBatch>(estimatedResultSize);
        this.startOffset = startOffset;
    }

    private void initializeCombinedList(List<PersisterStateBatch> batchesSoFar, List<PersisterStateBatch> newBatches) {
        boolean newBatchesEmpty;
        boolean soFarEmpty = batchesSoFar == null || batchesSoFar.isEmpty();
        boolean bl = newBatchesEmpty = newBatches == null || newBatches.isEmpty();
        if (soFarEmpty && newBatchesEmpty) {
            this.combinedBatchList = new ArrayList<PersisterStateBatch>();
        } else if (soFarEmpty) {
            this.combinedBatchList = new ArrayList<PersisterStateBatch>(newBatches);
        } else if (newBatchesEmpty) {
            this.combinedBatchList = new ArrayList<PersisterStateBatch>(batchesSoFar);
        } else {
            this.combinedBatchList = new ArrayList<PersisterStateBatch>(batchesSoFar.size() + newBatches.size());
            this.combinedBatchList.addAll(batchesSoFar);
            this.combinedBatchList.addAll(newBatches);
        }
    }

    public List<PersisterStateBatch> combineStateBatches() {
        this.pruneBatches();
        this.mergeBatches();
        return this.finalBatchList;
    }

    private void mergeBatches() {
        if (this.combinedBatchList.size() < 2) {
            this.finalBatchList = this.combinedBatchList;
            return;
        }
        this.sortedBatches = new TreeSet<PersisterStateBatch>(this.combinedBatchList);
        MergeCandidatePair overlapState = this.getMergeCandidatePair();
        while (overlapState != MergeCandidatePair.EMPTY) {
            PersisterStateBatch prev = overlapState.prev();
            PersisterStateBatch candidate = overlapState.candidate();
            this.sortedBatches.remove(prev);
            this.sortedBatches.remove(candidate);
            if (this.compareBatchDeliveryInfo(candidate, prev) == 0) {
                this.handleSameStateMerge(prev, candidate);
            } else {
                this.handleDiffStateOverlap(prev, candidate);
            }
            overlapState = this.getMergeCandidatePair();
        }
        this.finalBatchList.addAll(this.sortedBatches);
    }

    private int compareBatchDeliveryInfo(PersisterStateBatch b1, PersisterStateBatch b2) {
        int deltaCount = Short.compare(b1.deliveryCount(), b2.deliveryCount());
        if (deltaCount == 0) {
            return Byte.compare(b1.deliveryState(), b2.deliveryState());
        }
        return deltaCount;
    }

    private MergeCandidatePair getMergeCandidatePair() {
        if (this.sortedBatches == null || this.sortedBatches.isEmpty()) {
            return MergeCandidatePair.EMPTY;
        }
        Iterator<PersisterStateBatch> iter = this.sortedBatches.iterator();
        PersisterStateBatch prev = iter.next();
        LinkedList<PersisterStateBatch> nonOverlapping = new LinkedList<PersisterStateBatch>();
        while (iter.hasNext()) {
            PersisterStateBatch candidate = iter.next();
            if (candidate.firstOffset() <= prev.lastOffset() || prev.lastOffset() + 1L == candidate.firstOffset() && this.compareBatchDeliveryInfo(prev, candidate) == 0) {
                this.updateBatchContainers(nonOverlapping);
                return new MergeCandidatePair(prev, candidate);
            }
            nonOverlapping.add(prev);
            prev = candidate;
        }
        this.updateBatchContainers(nonOverlapping);
        return MergeCandidatePair.EMPTY;
    }

    private void updateBatchContainers(List<PersisterStateBatch> nonOverlappingBatches) {
        nonOverlappingBatches.forEach(this.sortedBatches::remove);
        this.finalBatchList.addAll(nonOverlappingBatches);
    }

    private void pruneBatches() {
        if (this.startOffset != -1L) {
            ArrayList<PersisterStateBatch> retainedBatches = new ArrayList<PersisterStateBatch>(this.combinedBatchList.size());
            this.combinedBatchList.forEach(batch -> {
                if (batch.lastOffset() < this.startOffset) {
                    return;
                }
                if (batch.firstOffset() >= this.startOffset) {
                    retainedBatches.add((PersisterStateBatch)batch);
                } else {
                    retainedBatches.add(new PersisterStateBatch(this.startOffset, batch.lastOffset(), batch.deliveryState(), batch.deliveryCount()));
                }
            });
            this.combinedBatchList = retainedBatches;
        }
    }

    private void handleSameStateMerge(PersisterStateBatch prev, PersisterStateBatch candidate) {
        this.sortedBatches.add(new PersisterStateBatch(prev.firstOffset(), Math.max(candidate.lastOffset(), prev.lastOffset()), prev.deliveryState(), prev.deliveryCount()));
    }

    private void handleDiffStateOverlap(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (candidate.firstOffset() == prev.firstOffset()) {
            this.handleDiffStateOverlapFirstOffsetAligned(prev, candidate);
        } else {
            this.handleDiffStateOverlapFirstOffsetNotAligned(prev, candidate);
        }
    }

    private void handleDiffStateOverlapFirstOffsetAligned(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (candidate.lastOffset() == prev.lastOffset()) {
            this.sortedBatches.add(candidate);
        } else if (this.compareBatchDeliveryInfo(candidate, prev) < 0) {
            this.sortedBatches.add(prev);
            this.sortedBatches.add(new PersisterStateBatch(prev.lastOffset() + 1L, candidate.lastOffset(), candidate.deliveryState(), candidate.deliveryCount()));
        } else {
            this.sortedBatches.add(candidate);
        }
    }

    private void handleDiffStateOverlapFirstOffsetNotAligned(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (candidate.lastOffset() < prev.lastOffset()) {
            this.handleDiffStateOverlapPrevSwallowsCandidate(prev, candidate);
        } else if (candidate.lastOffset() == prev.lastOffset()) {
            this.handleDiffStateOverlapLastOffsetAligned(prev, candidate);
        } else {
            this.handleDiffStateOverlapCandidateOffsetsLarger(prev, candidate);
        }
    }

    private void handleDiffStateOverlapPrevSwallowsCandidate(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (this.compareBatchDeliveryInfo(candidate, prev) < 0) {
            this.sortedBatches.add(prev);
        } else {
            this.sortedBatches.add(new PersisterStateBatch(prev.firstOffset(), candidate.firstOffset() - 1L, prev.deliveryState(), prev.deliveryCount()));
            this.sortedBatches.add(candidate);
            this.sortedBatches.add(new PersisterStateBatch(candidate.lastOffset() + 1L, prev.lastOffset(), prev.deliveryState(), prev.deliveryCount()));
        }
    }

    private void handleDiffStateOverlapLastOffsetAligned(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (this.compareBatchDeliveryInfo(candidate, prev) < 0) {
            this.sortedBatches.add(prev);
        } else {
            this.sortedBatches.add(new PersisterStateBatch(prev.firstOffset(), candidate.firstOffset() - 1L, prev.deliveryState(), prev.deliveryCount()));
            this.sortedBatches.add(candidate);
        }
    }

    private void handleDiffStateOverlapCandidateOffsetsLarger(PersisterStateBatch prev, PersisterStateBatch candidate) {
        if (this.compareBatchDeliveryInfo(candidate, prev) < 0) {
            this.sortedBatches.add(prev);
            this.sortedBatches.add(new PersisterStateBatch(prev.lastOffset() + 1L, candidate.lastOffset(), candidate.deliveryState(), candidate.deliveryCount()));
        } else {
            this.sortedBatches.add(new PersisterStateBatch(prev.firstOffset(), candidate.firstOffset() - 1L, prev.deliveryState(), prev.deliveryCount()));
            this.sortedBatches.add(candidate);
        }
    }

    static class MergeCandidatePair {
        private final PersisterStateBatch prev;
        private final PersisterStateBatch candidate;
        public static final MergeCandidatePair EMPTY = new MergeCandidatePair(null, null);

        public MergeCandidatePair(PersisterStateBatch prev, PersisterStateBatch candidate) {
            this.prev = prev;
            this.candidate = candidate;
        }

        public PersisterStateBatch prev() {
            return this.prev;
        }

        public PersisterStateBatch candidate() {
            return this.candidate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeCandidatePair)) {
                return false;
            }
            MergeCandidatePair that = (MergeCandidatePair)o;
            return Objects.equals(this.prev, that.prev) && Objects.equals(this.candidate, that.candidate);
        }

        public int hashCode() {
            return Objects.hash(this.prev, this.candidate);
        }
    }
}

