/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.ysandbox;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.CalendarListener;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.zinternaltools.CalendarSelectionEvent;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.github.lgooddatepicker.zinternaltools.YearMonthChangeEvent;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.time.LocalDate;
import java.time.YearMonth;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class CalendarPanelTest {
    static JFrame frame = new JFrame();
    static JLabel informationLabel = new JLabel();
    static JPanel container = new JPanel();

    public static void main(String[] args2) {
        CalendarPanelTest.initializeComponents();
        DatePickerSettings settings2 = new DatePickerSettings();
        CalendarPanel calendarPanel = new CalendarPanel(settings2);
        calendarPanel.addCalendarListener(new SampleCalendarListener());
        container.add(calendarPanel);
        frame.setVisible(true);
    }

    private static void initializeComponents() {
        frame.setTitle("LGoodDatePicker Independent Calendar Panel Demo " + InternalUtilities.getProjectVersionString());
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        frame.getContentPane().add(mainPanel);
        container.setLayout(new GridBagLayout());
        mainPanel.add(informationLabel);
        mainPanel.add(new JLabel(" "));
        mainPanel.add(new JLabel(" "));
        mainPanel.add(container);
        informationLabel.setOpaque(true);
        informationLabel.setBackground(Color.white);
        informationLabel.setBorder(new CompoundBorder(new LineBorder(Color.black), new EmptyBorder(2, 4, 2, 4)));
        informationLabel.setText("The selected date will be displayed here.");
        informationLabel.setAlignmentX(0.5f);
        frame.pack();
        frame.validate();
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
    }

    private static class SampleCalendarListener
    implements CalendarListener {
        private SampleCalendarListener() {
        }

        @Override
        public void selectedDateChanged(CalendarSelectionEvent event) {
            LocalDate oldDate = event.getOldDate();
            LocalDate newDate = event.getNewDate();
            String oldDateString = PickerUtilities.localDateToString(oldDate, "(null)");
            String newDateString = PickerUtilities.localDateToString(newDate, "(null)");
            String messageStart = "The selected date has changed from: ";
            String fullMessage = messageStart + oldDateString + " to: " + newDateString + ".";
            fullMessage = fullMessage + (event.isDuplicate() ? "(Event marked as duplicate.)" : "");
            informationLabel.setText(fullMessage);
        }

        @Override
        public void yearMonthChanged(YearMonthChangeEvent event) {
            YearMonth oldYearMonth = event.getOldYearMonth();
            YearMonth newYearMonth = event.getNewYearMonth();
            String oldYearMonthString = oldYearMonth.toString();
            String newYearMonthString = newYearMonth.toString();
            String messageStart = "The displayed YearMonth has changed from: '";
            String fullMessage = messageStart + oldYearMonthString + "' to '" + newYearMonthString + "'. ";
            fullMessage = fullMessage + (event.isDuplicate() ? "(Event marked as duplicate.)" : "");
        }
    }
}

