/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.launching.DirectOutputRedirection;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;

public class GSettingsHelper {
    public static final File G_SETTINGS_EXECUTABLE = new File("/usr/bin/gsettings");

    public static boolean isAvailable() {
        return G_SETTINGS_EXECUTABLE.isFile();
    }

    public static String getString(final String schema, final String key) throws UserCanceledException, IOException {
        if (GSettingsHelper.isAvailable()) {
            return HelperCommunication.getInstance().fetchStringChecked(ExecutionContext.UNELEVATED, new FetchStringAction(){

                @Override
                protected String fetchValue(Context context) throws Exception {
                    LaunchHelper.LaunchResult launchResult = LaunchHelper.launchApplicationWithResult(new LaunchDescriptor(G_SETTINGS_EXECUTABLE).arguments("get", schema, key).wait(true).waitForStreams(true).stdoutRedirection(new DirectOutputRedirection()));
                    if (launchResult == null) {
                        throw new IOException("could not execute gsettings");
                    }
                    if (launchResult.getReturnCode() != 0) {
                        return null;
                    }
                    if (launchResult.getOutput() == null) {
                        throw new IOException("gsettings returned no output");
                    }
                    for (String line : StringUtil.getLines(launchResult.getOutput())) {
                        String trimmed = line.trim();
                        if (!trimmed.startsWith("'") || !trimmed.endsWith("'")) continue;
                        return trimmed.substring(1, trimmed.length() - 1);
                    }
                    return null;
                }
            });
        }
        return null;
    }
}

