/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.crt.eventstream.ServerConnection;
import software.amazon.awssdk.crt.eventstream.ServerConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.ServerConnectionContinuationHandler;

public abstract class ServerConnectionHandler
implements AutoCloseable {
    protected ServerConnection connection;

    protected ServerConnectionHandler(ServerConnection connection) {
        this.connection = connection;
        this.connection.getClosedFuture().whenComplete((shutdownReason, ex) -> this.onConnectionClosed((int)shutdownReason));
    }

    protected abstract void onProtocolMessage(List<Header> var1, byte[] var2, MessageType var3, int var4);

    private void onProtocolMessage(byte[] headersPayload, byte[] payload, int messageType, int messageFlags) {
        ArrayList<Header> headers = new ArrayList<Header>();
        ByteBuffer headersBuffer = ByteBuffer.wrap(headersPayload);
        while (headersBuffer.hasRemaining()) {
            Header header = Header.fromByteBuffer(headersBuffer);
            headers.add(header);
        }
        this.onProtocolMessage(headers, payload, MessageType.fromEnumValue(messageType), messageFlags);
    }

    protected abstract ServerConnectionContinuationHandler onIncomingStream(ServerConnectionContinuation var1, String var2);

    private ServerConnectionContinuationHandler onIncomingStream(ServerConnectionContinuation continuation, byte[] operationName) {
        String operationNameStr = new String(operationName, StandardCharsets.UTF_8);
        return this.onIncomingStream(continuation, operationNameStr);
    }

    protected void onConnectionClosed(int shutdownReason) {
        this.close();
    }

    @Override
    public void close() {
        if (this.connection.isConnectionOpen()) {
            this.connection.closeConnection(0);
        }
        this.connection.decRef();
        this.connection = null;
    }
}

