/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import com.oracle.labs.mlrg.olcut.util.IOSpliterator;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtil {
    static final Object NONE = new Object();

    private StreamUtil() {
    }

    public static <T> Stream<T> boundParallelism(Stream<T> inputStream) {
        BoundedSpliterator boundedSpliterator = new BoundedSpliterator(inputStream.spliterator());
        return StreamSupport.stream(boundedSpliterator, true);
    }

    public static <A, B, C> Stream<C> zip(Stream<? extends A> a, Stream<? extends B> b, BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator as = Objects.requireNonNull(a).spliterator();
        Spliterator bs = Objects.requireNonNull(b).spliterator();
        int characteristics = as.characteristics() & bs.characteristics() & 0xFFFFFFFA;
        long size = Math.min(as.estimateSize(), bs.estimateSize());
        ZipperSpliterator<? super A, ? super B, ? extends C> cs = new ZipperSpliterator<A, B, C>(as, bs, zipper, size, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(cs, true) : StreamSupport.stream(cs, false);
    }

    public static <A, B, C> Stream<C> zipIO(Stream<? extends A> a, Stream<? extends B> b, BiFunction<? super A, ? super B, ? extends C> zipper) {
        Objects.requireNonNull(zipper);
        Spliterator as = Objects.requireNonNull(a).spliterator();
        Spliterator bs = Objects.requireNonNull(b).spliterator();
        int characteristics = as.characteristics() & bs.characteristics() & 0xFFFFFFFA;
        long size = Math.min(as.estimateSize(), bs.estimateSize());
        ZipperSpliteratorIO<? super A, ? super B, ? extends C> cs = new ZipperSpliteratorIO<A, B, C>(as, bs, zipper, size, characteristics);
        return a.isParallel() || b.isParallel() ? StreamSupport.stream(cs, true) : StreamSupport.stream(cs, false);
    }

    private static class BoundedSpliterator<T>
    implements Spliterator<T> {
        private static final Logger logger = Logger.getLogger(BoundedSpliterator.class.getName());
        private final Spliterator<T> spliterator;
        private long targetSize = -1L;

        public BoundedSpliterator(Spliterator<T> spliterator) {
            this.spliterator = spliterator;
        }

        public BoundedSpliterator(Spliterator<T> spliterator, long targetSize) {
            this.spliterator = spliterator;
            this.targetSize = targetSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.spliterator.tryAdvance(action);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.spliterator.forEachRemaining(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            Spliterator<T> tmp;
            if (this.targetSize == -1L) {
                Thread curThread = Thread.currentThread();
                if (curThread instanceof ForkJoinWorkerThread) {
                    this.targetSize = this.spliterator.estimateSize() / (long)(((ForkJoinWorkerThread)curThread).getPool().getParallelism() << 2);
                    logger.log(Level.FINEST, "In FJP - setting targetSize to " + this.targetSize);
                } else {
                    this.targetSize = this.spliterator.estimateSize() / (long)(ForkJoinPool.getCommonPoolParallelism() << 2);
                    logger.log(Level.FINEST, "Common pool - setting targetSize to " + this.targetSize);
                }
            }
            if (this.targetSize < this.spliterator.estimateSize() && (tmp = this.spliterator.trySplit()) != null) {
                return new BoundedSpliterator<T>(tmp, this.targetSize);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.spliterator.estimateSize();
        }

        @Override
        public long getExactSizeIfKnown() {
            return this.spliterator.getExactSizeIfKnown();
        }

        @Override
        public int characteristics() {
            return this.spliterator.characteristics();
        }

        @Override
        public boolean hasCharacteristics(int characteristics) {
            return this.spliterator.hasCharacteristics(characteristics);
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.spliterator.getComparator();
        }
    }

    private static final class ZipperSpliteratorIO<A, B, C>
    extends IOSpliterator<C>
    implements Consumer<Object> {
        final Spliterator<A> as;
        final Spliterator<B> bs;
        final BiFunction<? super A, ? super B, ? extends C> zipper;
        Object a;
        Object b;

        ZipperSpliteratorIO(Spliterator<A> as, Spliterator<B> bs, BiFunction<? super A, ? super B, ? extends C> zipper, long est, int additionalCharacteristics) {
            super(additionalCharacteristics, est);
            this.as = as;
            this.bs = bs;
            this.zipper = zipper;
            this.a = NONE;
        }

        @Override
        public void accept(Object aOrB) {
            if (this.a == NONE) {
                this.a = aOrB;
            } else {
                this.b = aOrB;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super C> action) {
            if (this.as.tryAdvance(this) && this.bs.tryAdvance(this)) {
                Object aTmp = this.a;
                this.a = NONE;
                action.accept(this.zipper.apply(aTmp, this.b));
                return true;
            }
            return false;
        }
    }

    private static final class ZipperSpliterator<A, B, C>
    extends Spliterators.AbstractSpliterator<C>
    implements Consumer<Object> {
        final Spliterator<A> as;
        final Spliterator<B> bs;
        final BiFunction<? super A, ? super B, ? extends C> zipper;
        Object a;
        Object b;

        ZipperSpliterator(Spliterator<A> as, Spliterator<B> bs, BiFunction<? super A, ? super B, ? extends C> zipper, long est, int additionalCharacteristics) {
            super(est, additionalCharacteristics);
            this.as = as;
            this.bs = bs;
            this.zipper = zipper;
            this.a = NONE;
        }

        @Override
        public void accept(Object aOrB) {
            if (this.a == NONE) {
                this.a = aOrB;
            } else {
                this.b = aOrB;
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super C> action) {
            if (this.as.tryAdvance(this) && this.bs.tryAdvance(this)) {
                Object aTmp = this.a;
                this.a = NONE;
                action.accept(this.zipper.apply(aTmp, this.b));
                return true;
            }
            return false;
        }
    }
}

