/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.factory;

import java.util.Map;
import lombok.Generated;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.env.Environment;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.Processor;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.TextImageEmbeddingProcessor;
import org.opensearch.neuralsearch.processor.optimization.TextImageEmbeddingInferenceFilter;
import org.opensearch.transport.client.OpenSearchClient;

public class TextImageEmbeddingProcessorFactory
implements Processor.Factory {
    private final OpenSearchClient openSearchClient;
    private final MLCommonsClientAccessor clientAccessor;
    private final Environment environment;
    private final ClusterService clusterService;

    public Processor create(Map<String, Processor.Factory> processorFactories, String tag, String description, Map<String, Object> config) throws Exception {
        boolean skipExisting;
        String modelId = ConfigurationUtils.readStringProperty((String)"text_image_embedding", (String)tag, config, (String)"model_id");
        String embedding = ConfigurationUtils.readStringProperty((String)"text_image_embedding", (String)tag, config, (String)"embedding");
        Map fieldMap = ConfigurationUtils.readMap((String)"text_image_embedding", (String)tag, config, (String)"field_map");
        return new TextImageEmbeddingProcessor(tag, description, modelId, embedding, fieldMap, skipExisting, (skipExisting = ConfigurationUtils.readBooleanProperty((String)"text_image_embedding", (String)tag, config, (String)"skip_existing", (boolean)false)) ? new TextImageEmbeddingInferenceFilter() : null, this.openSearchClient, this.clientAccessor, this.environment, this.clusterService);
    }

    @Generated
    public TextImageEmbeddingProcessorFactory(OpenSearchClient openSearchClient, MLCommonsClientAccessor clientAccessor, Environment environment, ClusterService clusterService) {
        this.openSearchClient = openSearchClient;
        this.clientAccessor = clientAccessor;
        this.environment = environment;
        this.clusterService = clusterService;
    }
}

