/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.collector;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.grouping.GroupSelector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.opensearch.index.fielddata.AbstractSortedDocValues;
import org.opensearch.index.mapper.MappedFieldType;

abstract class CollapseDocSourceGroupSelector<T>
extends GroupSelector<T> {
    protected final String field;

    CollapseDocSourceGroupSelector(String field) {
        this.field = field;
    }

    public void setGroups(Collection<SearchGroup<T>> groups) {
        throw new UnsupportedOperationException();
    }

    private static DocValuesType getDocValuesType(LeafReader in, String field) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            return fi.getDocValuesType();
        }
        return null;
    }

    static class Keyword
    extends CollapseDocSourceGroupSelector<BytesRef> {
        private SortedDocValues values;
        private int ord;

        Keyword(MappedFieldType fieldType) {
            super(fieldType.name());
        }

        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.ord = this.values.ordValue();
                return GroupSelector.State.ACCEPT;
            }
            this.ord = -1;
            return GroupSelector.State.SKIP;
        }

        public BytesRef currentValue() {
            if (this.ord == -1) {
                return null;
            }
            try {
                return this.values.lookupOrd(this.ord);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public BytesRef copyValue() {
            BytesRef value = this.currentValue();
            if (value == null) {
                return null;
            }
            return BytesRef.deepCopyOf((BytesRef)value);
        }

        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = CollapseDocSourceGroupSelector.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptySorted();
                return;
            }
            switch (type) {
                case SORTED: {
                    this.values = DocValues.getSorted((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_SET: {
                    final SortedSetDocValues sorted = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedSetDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new AbstractSortedDocValues(this){
                        private int ord;

                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                this.ord = (int)sorted.nextOrd();
                                if (sorted.docValueCount() != 1) {
                                    throw new IllegalStateException(String.format(Locale.ROOT, "failed to collapse %d, the collapse field must be single valued", target));
                                }
                                return true;
                            }
                            return false;
                        }

                        public int docID() {
                            return sorted.docID();
                        }

                        public int ordValue() {
                            return this.ord;
                        }

                        public BytesRef lookupOrd(int ord) throws IOException {
                            return sorted.lookupOrd((long)ord);
                        }

                        public int getValueCount() {
                            return (int)sorted.getValueCount();
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format(Locale.ROOT, "unexpected doc values type `%s` for field `%s`", type, this.field));
                }
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }

    static class Numeric
    extends CollapseDocSourceGroupSelector<Long> {
        private NumericDocValues values;
        private long value;
        private boolean hasValue;

        Numeric(MappedFieldType fieldType) {
            super(fieldType.name());
        }

        public GroupSelector.State advanceTo(int doc) throws IOException {
            if (this.values.advanceExact(doc)) {
                this.hasValue = true;
                this.value = this.values.longValue();
                return GroupSelector.State.ACCEPT;
            }
            this.hasValue = false;
            return GroupSelector.State.SKIP;
        }

        public Long currentValue() {
            return this.hasValue ? Long.valueOf(this.value) : null;
        }

        public Long copyValue() {
            return this.currentValue();
        }

        public void setNextReader(LeafReaderContext readerContext) throws IOException {
            LeafReader reader = readerContext.reader();
            DocValuesType type = CollapseDocSourceGroupSelector.getDocValuesType(reader, this.field);
            if (type == null || type == DocValuesType.NONE) {
                this.values = DocValues.emptyNumeric();
                return;
            }
            switch (type) {
                case NUMERIC: {
                    this.values = DocValues.getNumeric((LeafReader)reader, (String)this.field);
                    break;
                }
                case SORTED_NUMERIC: {
                    final SortedNumericDocValues sorted = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
                    this.values = DocValues.unwrapSingleton((SortedNumericDocValues)sorted);
                    if (this.values != null) break;
                    this.values = new AbstractNumericDocValues(this){
                        private long value;

                        public boolean advanceExact(int target) throws IOException {
                            if (sorted.advanceExact(target)) {
                                if (sorted.docValueCount() > 1) {
                                    throw new IllegalStateException(String.format(Locale.ROOT, "failed to collapse %d, the collapse field must be single valued", target));
                                }
                                this.value = sorted.nextValue();
                                return true;
                            }
                            return false;
                        }

                        public int docID() {
                            return sorted.docID();
                        }

                        public long longValue() throws IOException {
                            return this.value;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format(Locale.ROOT, "unexpected doc values type %s` for field `%s`", type, this.field));
                }
            }
        }

        public void setScorer(Scorable scorer) throws IOException {
        }
    }
}

