/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.routing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.security.auditlog.config.ThreadPoolConfig;
import org.opensearch.security.auditlog.impl.AuditCategory;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.routing.AsyncStoragePool;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.security.auditlog.sink.SinkProvider;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class AuditMessageRouter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    final AuditLogSink defaultSink;
    volatile Map<AuditCategory, List<AuditLogSink>> categorySinks;
    final SinkProvider sinkProvider;
    final AsyncStoragePool storagePool;

    public AuditMessageRouter(Settings settings, Client clientProvider, ThreadPool threadPool, Path configPath, ClusterService clusterService) {
        this(new SinkProvider(settings, clientProvider, threadPool, configPath, clusterService), new AsyncStoragePool(ThreadPoolConfig.getConfig(settings)));
    }

    @VisibleForTesting
    public AuditMessageRouter(SinkProvider sinkProvider, AsyncStoragePool storagePool) {
        this.sinkProvider = sinkProvider;
        this.storagePool = storagePool;
        this.defaultSink = sinkProvider.getDefaultSink();
        if (this.defaultSink == null) {
            this.log.warn("No default storage available, audit log may not work properly. Please check configuration.");
        }
    }

    public boolean isEnabled() {
        return this.defaultSink != null;
    }

    public final void route(AuditMessage msg) {
        if (!this.isEnabled()) {
            this.log.error("#route(AuditMessage) called but message router is disabled");
            return;
        }
        Preconditions.checkState((this.categorySinks != null ? 1 : 0) != 0, (Object)"categorySinks is null, prior to route() call enableRoutes().");
        List<AuditLogSink> auditLogSinks = this.categorySinks.get((Object)msg.getCategory());
        if (auditLogSinks == null) {
            this.store(this.defaultSink, msg);
        } else {
            auditLogSinks.stream().forEach(sink -> this.store((AuditLogSink)sink, msg));
        }
    }

    public final void close() {
        this.log.info("Closing {}", (Object)this.getClass().getSimpleName());
        this.storagePool.close();
        this.sinkProvider.close();
    }

    protected final void close(List<AuditLogSink> sinks) {
        for (AuditLogSink sink : sinks) {
            try {
                this.log.info("Closing {}", (Object)sink.getClass().getSimpleName());
                sink.close();
            }
            catch (Exception ex) {
                this.log.info("Could not close delegate '{}' due to '{}'", (Object)sink.getClass().getSimpleName(), (Object)ex.getMessage());
            }
        }
    }

    public final void enableRoutes(Settings settings) {
        Preconditions.checkState((boolean)this.isEnabled(), (Object)"AuditMessageRouter is disabled");
        if (this.categorySinks != null) {
            return;
        }
        Map<String, Object> routesConfiguration = Utils.convertJsonToxToStructuredMap((ToXContent)settings.getAsSettings("plugins.security.audit.routes"));
        EnumSet<AuditCategory> presentAuditCategory = EnumSet.noneOf(AuditCategory.class);
        this.categorySinks = (Map)routesConfiguration.entrySet().stream().peek(entry -> this.log.trace("Setting up routes for endpoint {}, configuration is {}", entry.getKey(), entry.getValue())).map(entry -> {
            String categoryName = (String)entry.getKey();
            try {
                AuditCategory auditCategory = AuditCategory.valueOf(categoryName.toUpperCase());
                return Maps.immutableEntry((Object)((Object)auditCategory), this.createSinksForCategory(auditCategory, (Map)entry.getValue()));
            }
            catch (IllegalArgumentException e) {
                this.log.error("Invalid category '{}' found in routing configuration. Must be one of: {}", (Object)categoryName, (Object)AuditCategory.values());
                return null;
            }
        }).filter(entry -> {
            if (entry != null) {
                AuditCategory category = (AuditCategory)((Object)((Object)entry.getKey()));
                List auditLogSinks = (List)entry.getValue();
                if (auditLogSinks.isEmpty()) {
                    this.log.debug("No valid endpoints found for category {}.", (Object)category);
                    return false;
                }
                if (presentAuditCategory.add(category)) {
                    this.log.debug("Created {} endpoints for category {}", (Object)auditLogSinks.size(), (Object)category);
                    return true;
                }
                this.log.warn("Duplicate routing configuration {} detected for category {}, skipping.", (Object)auditLogSinks, (Object)category);
            }
            return false;
        }).collect(Maps.toImmutableEnumMap(Map.Entry::getKey, Map.Entry::getValue));
        this.log.warn("No endpoint configured for categories {}, using default endpoint", EnumSet.complementOf(presentAuditCategory));
    }

    private final List<AuditLogSink> createSinksForCategory(AuditCategory category, Map<String, List<String>> configuration) {
        LinkedList<AuditLogSink> sinksForCategory = new LinkedList<AuditLogSink>();
        List<String> sinks = configuration.get("endpoints");
        if (sinks != null && !sinks.isEmpty()) {
            for (String sinkName : sinks) {
                AuditLogSink sink = this.sinkProvider.getSink(sinkName);
                if (sink != null && !sinksForCategory.contains(sink)) {
                    sinksForCategory.add(sink);
                    continue;
                }
                this.log.error("Configured endpoint '{}' not available", (Object)sinkName);
            }
        }
        if (sinksForCategory.isEmpty()) {
            this.log.error("No endpoints configured for category {}", (Object)category);
        }
        return sinksForCategory;
    }

    private final void store(AuditLogSink sink, AuditMessage msg) {
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (sink.isHandlingBackpressure()) {
            sink.store(msg);
            if (isTraceEnabled) {
                this.log.trace("stored on sink {} synchronously", (Object)sink.getClass().getSimpleName());
            }
        } else {
            this.storagePool.submit(msg, sink);
            if (isTraceEnabled) {
                this.log.trace("will store on sink {} asynchronously", (Object)sink.getClass().getSimpleName());
            }
        }
    }
}

