/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.guesses;

import com.nulabinc.zxcvbn.Context;
import com.nulabinc.zxcvbn.Pattern;
import com.nulabinc.zxcvbn.Scoring;
import com.nulabinc.zxcvbn.guesses.BaseGuess;
import com.nulabinc.zxcvbn.guesses.BruteforceGuess;
import com.nulabinc.zxcvbn.guesses.DateGuess;
import com.nulabinc.zxcvbn.guesses.DictionaryGuess;
import com.nulabinc.zxcvbn.guesses.Guess;
import com.nulabinc.zxcvbn.guesses.RegexGuess;
import com.nulabinc.zxcvbn.guesses.RepeatGuess;
import com.nulabinc.zxcvbn.guesses.SequenceGuess;
import com.nulabinc.zxcvbn.guesses.SpatialGuess;
import com.nulabinc.zxcvbn.matchers.Match;
import java.util.EnumMap;
import java.util.Map;

public class EstimateGuess
extends BaseGuess {
    private final CharSequence password;
    private final Map<Pattern, Guess> patternGuessMap = new EnumMap<Pattern, Guess>(Pattern.class);

    public EstimateGuess(Context context, CharSequence password) {
        super(context);
        this.password = password;
        this.patternGuessMap.put(Pattern.Bruteforce, new BruteforceGuess(context));
        this.patternGuessMap.put(Pattern.Dictionary, new DictionaryGuess(context));
        this.patternGuessMap.put(Pattern.Spatial, new SpatialGuess(context));
        this.patternGuessMap.put(Pattern.Repeat, new RepeatGuess(context));
        this.patternGuessMap.put(Pattern.Sequence, new SequenceGuess(context));
        this.patternGuessMap.put(Pattern.Regex, new RegexGuess(context));
        this.patternGuessMap.put(Pattern.Date, new DateGuess(context));
    }

    @Override
    public double exec(Match match) {
        Guess guess;
        if (match.guesses != null) {
            return match.guesses;
        }
        int minGuesses = 1;
        if (match.tokenLength() < this.password.length()) {
            minGuesses = match.tokenLength() == 1 ? 10 : 50;
        }
        double guesses = (guess = this.patternGuessMap.get((Object)match.pattern)) != null ? guess.exec(match) : 0.0;
        match.guesses = Math.max(guesses, (double)minGuesses);
        match.guessesLog10 = Scoring.log10(match.guesses);
        return match.guesses;
    }
}

