/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;

public class EntityImageTransitionLabel
extends AbstractEntityImage {
    private final TextBlock textBlock;
    private static final double MARGIN = 4.0;

    public EntityImageTransitionLabel(Entity entity) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fontConfiguration = FontConfiguration.create(this.getSkinParam(), FontParam.ARROW, stereotype);
        Display display = this.getEntity().getDisplay();
        this.textBlock = display != null && !Display.isNull(display) ? display.create(fontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam()) : Display.create(this.getEntity().getName()).create(fontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        try {
            XDimension2D textDim = this.textBlock.calculateDimension(stringBounder);
            return textDim.delta(8.0, 8.0);
        }
        catch (Exception e) {
            return new XDimension2D(20.0, 20.0);
        }
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimText = this.textBlock.calculateDimension(stringBounder);
        URectangle rect = URectangle.build(dimTotal.getWidth(), dimTotal.getHeight()).rounded(5.0);
        ug.draw(rect);
        double xText = (dimTotal.getWidth() - dimText.getWidth()) / 2.0;
        double yText = (dimTotal.getHeight() - dimText.getHeight()) / 2.0;
        this.textBlock.drawU(ug.apply(new UTranslate(xText, yText)));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

