# Interface methods for submodule: ResourceProbe
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate



# Interface methods for class: ResourceProbe
class ResourceProbeProxy():
	def GetType(self) -> str:
		""""""
		...

	def GetUnit(self) -> str:
		""""""
		...

	def Start(self) -> None:
		""""""
		...

	def Stop(self) -> None:
		""""""
		...

	def GetNumberOfStarts(self) -> int:
		""""""
		...

	def GetNumberOfStops(self) -> int:
		""""""
		...

	def GetNumberOfIteration(self) -> int:
		""""""
		...

	def GetInstantValue(self) -> float:
		""""""
		...

	def GetTotal(self) -> float:
		""""""
		...

	def GetMean(self) -> float:
		""""""
		...

	def Reset(self) -> None:
		""""""
		...

	def GetMinimum(self) -> float:
		""""""
		...

	def GetMaximum(self) -> float:
		""""""
		...

	def GetStandardDeviation(self) -> float:
		""""""
		...

	def GetStandardError(self) -> float:
		""""""
		...

	def SetNameOfProbe(self, nameOfProbe) -> None:
		""""""
		...

	def GetNameOfProbe(self) -> str:
		""""""
		...

	def PrintSystemInformation(self, os = ...) -> None:
		""""""
		...

	def Report(self, os = ..., printSystemInfo: bool = True, printReportHead: bool = True, useTabs: bool = False) -> None:
		""""""
		...

	def ExpandedReport(self, os = ..., printSystemInfo: bool = True, printReportHead: bool = True, useTabs: bool = False) -> None:
		""""""
		...

	def JSONReport(self, os = ...) -> None:
		""""""
		...

	def PrintJSONSystemInformation(self, os = ...) -> None:
		""""""
		...

