/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.MapNode$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class BitmapIndexedMapNode<K, V>
extends MapNode<K, V> {
    private int dataMap;
    private int nodeMap;
    private Object[] content;
    private int[] originalHashes;
    private int size;
    private int cachedJavaKeySetHashCode;

    public final int dataMap() {
        return this.dataMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void dataMap_$eq(int x$1) {
        void var1_1;
        this.dataMap = var1_1;
    }

    public final int nodeMap() {
        return this.nodeMap;
    }

    /*
     * WARNING - void declaration
     */
    public final void nodeMap_$eq(int x$1) {
        void var1_1;
        this.nodeMap = var1_1;
    }

    public final Object[] content() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    public final void content_$eq(Object[] x$1) {
        void var1_1;
        this.content = var1_1;
    }

    public final int[] originalHashes() {
        return this.originalHashes;
    }

    /*
     * WARNING - void declaration
     */
    public final void originalHashes_$eq(int[] x$1) {
        void var1_1;
        this.originalHashes = var1_1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void size_$eq(int x$1) {
        void var1_1;
        this.size = var1_1;
    }

    @Override
    public final int cachedJavaKeySetHashCode() {
        return this.cachedJavaKeySetHashCode;
    }

    /*
     * WARNING - void declaration
     */
    public final void cachedJavaKeySetHashCode_$eq(int x$1) {
        void var1_1;
        this.cachedJavaKeySetHashCode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K getKey(int index) {
        void var1_1;
        return (K)this.content()[2 * var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getValue(int index) {
        void var1_1;
        return (V)this.content()[2 * var1_1 + 1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Tuple2<K, V> getPayload(int index) {
        void var1_1;
        return new Tuple2<Object, Object>(this.content()[2 * index], this.content()[2 * var1_1 + 1]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getHash(int index) {
        void var1_1;
        return this.originalHashes()[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final MapNode<K, V> getNode(int index) {
        void var1_1;
        return (MapNode)this.content()[this.content().length - 1 - var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V apply(K key, int originalHash, int keyHash, int shift) {
        void var1_1;
        void var2_2;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            if (BoxesRunTime.equals(key, this.content()[2 * index])) {
                return (V)this.content()[2 * var2_2 + 1];
            }
            throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(key).toString());
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var3_3;
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos))).apply(key, (int)var2_2, (int)var3_3, shift + 5);
        }
        throw new NoSuchElementException(new StringBuilder(15).append("key not found: ").append(var1_1).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Option<V> get(K key, int originalHash, int keyHash, int shift) {
        void var2_2;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            void var3_4;
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            Object key0 = this.content()[2 * index];
            if (BoxesRunTime.equals(key, var3_4)) {
                return new Some<Object>(this.content()[2 * var2_2 + 1]);
            }
            return None$.MODULE$;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var3_3;
            void var1_1;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((MapNode)this.getNode(index)).get(var1_1, (int)var2_2, (int)var3_3, shift + 5);
        }
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> V1 getOrElse(K key, int originalHash, int keyHash, int shift, Function0<V1> f) {
        void var2_2;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            void var3_4;
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            Object key0 = this.content()[2 * index];
            if (BoxesRunTime.equals(key, var3_4)) {
                return (V1)this.content()[2 * var2_2 + 1];
            }
            return f.apply();
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var3_3;
            void var1_1;
            int index = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            return ((MapNode)this.getNode(index)).getOrElse(var1_1, (int)var2_2, (int)var3_3, shift + 5, f);
        }
        return f.apply();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(K key, int originalHash, int keyHash, int shift) {
        void var3_3;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            int index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            return this.originalHashes()[index] == originalHash && BoxesRunTime.equals(key, this.content()[2 * var3_3]);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var2_2;
            void var1_1;
            return ((MapNode)this.getNode(Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos))).containsKey(var1_1, (int)var2_2, (int)var3_3, shift + 5);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> BitmapIndexedMapNode<K, V1> updated(K key, V1 value, int originalHash, int keyHash, int shift, boolean replaceValue) {
        void var2_2;
        void var1_1;
        MapNode<Object, Object> subNodeNew;
        void var3_3;
        int key0Hash;
        int index;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            Object key0 = this.content()[2 * index];
            int key0UnimprovedHash = this.originalHashes()[index];
            if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                if (replaceValue) {
                    void var3_4;
                    Object value0 = this.content()[2 * index + 1];
                    if (key0 == key && var3_4 == value) {
                        return this;
                    }
                    return this.copyAndSetValue(bitpos, key, value);
                }
                return this;
            }
            Object value0 = this.content()[2 * index + 1];
            key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
            subNodeNew = this.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, key, value, (int)var3_3, keyHash, shift + 5);
            return this.copyAndMigrateFromInlineToNode(bitpos, key0Hash, subNodeNew);
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var6_7;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), key0Hash, bitpos);
            Node subNode = this.getNode(index);
            subNodeNew = ((MapNode)subNode).updated(subNodeNew, value, (int)var3_3, keyHash, shift + 5, (boolean)var6_7);
            if (subNodeNew == subNode) {
                return this;
            }
            return this.copyAndSetNode(bitpos, (MapNode<K, V1>)subNode, (MapNode<K, V1>)var1_1);
        }
        return this.copyAndInsertValue(bitpos, var1_1, (int)var3_3, keyHash, var2_2);
    }

    /*
     * Unable to fully structure code
     */
    public final <V1> int updateWithShallowMutations(K key, V1 value, int originalHash, int keyHash, int shift, int shallowlyMutableNodeMap) {
        block6: {
            mask = keyHash >>> shift & 31;
            bitpos = 1 << mask;
            if ((this.dataMap() & bitpos) != 0) {
                index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
                key0 = this.content()[2 * index];
                key0UnimprovedHash = this.originalHashes()[index];
                if (key0UnimprovedHash == originalHash && BoxesRunTime.equals(key0, key)) {
                    value0 = this.content()[2 * index + 1];
                    if (key0 != key || var3_5 != value) {
                        dataIx = this.dataIndex(bitpos);
                        idx = 2 * dataIx;
                        this.content()[idx + 1] = value;
                    }
                    return shallowlyMutableNodeMap;
                }
                value0 = this.content()[2 * index + 1];
                key0Hash = Hashing$.MODULE$.improve(key0UnimprovedHash);
                subNodeNew = this.mergeTwoKeyValPairs(key0, value0, key0UnimprovedHash, key0Hash, idx, value, (int)var3_4, keyHash, shift + 5);
                this.migrateFromInlineToNodeInPlace(bitpos, key0Hash, subNodeNew);
                return shallowlyMutableNodeMap | bitpos;
            }
            if ((this.nodeMap() & bitpos) == 0) break block6;
            index = Node$.MODULE$.indexFrom(this.nodeMap(), (int)value0, bitpos);
            subNode = this.getNode(index);
            subNodeSize = subNode.size();
            subNodeHashCode = subNode.cachedJavaKeySetHashCode();
            returnMutableNodeMap = shallowlyMutableNodeMap;
            if (!(subNode instanceof BitmapIndexedMapNode)) ** GOTO lbl-1000
            var12_21 = (BitmapIndexedMapNode)subNode;
            if ((bitpos & shallowlyMutableNodeMap) != 0) {
                var12_21.updateWithShallowMutations(subNodeNew, value, (int)var3_4, keyHash, shift + 5, 0);
                v0 = var12_21;
            } else lbl-1000:
            // 2 sources

            {
                if ((result = subNode.updated(subNodeNew, value, (int)var3_4, keyHash, shift + 5, true)) != subNode) {
                    returnMutableNodeMap = shallowlyMutableNodeMap | bitpos;
                }
                v0 = subNodeNew;
            }
            this.content()[this.content().length - 1 - this.nodeIndex((int)bitpos)] = subNodeNew = v0;
            v1 = this;
            v1.size_$eq(v1.size() - subNodeSize + subNodeNew.size());
            v2 = this;
            v2.cachedJavaKeySetHashCode_$eq(v2.cachedJavaKeySetHashCode() - subNodeHashCode + var1_1.cachedJavaKeySetHashCode());
            return returnMutableNodeMap;
        }
        dataIx = this.dataIndex(bitpos);
        idx = 2 * dataIx;
        src = this.content();
        dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = var1_1;
        dst[idx + 1] = var2_3;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        v3 = this;
        v3.dataMap_$eq(v3.dataMap() | bitpos);
        this.content_$eq(dst);
        v4 = this;
        v4.originalHashes_$eq(v4.insertElement(this.originalHashes(), dataIx, (int)var3_4));
        v5 = this;
        v5.size_$eq(v5.size() + 1);
        v6 = this;
        v6.cachedJavaKeySetHashCode_$eq(v6.cachedJavaKeySetHashCode() + keyHash);
        return shallowlyMutableNodeMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> BitmapIndexedMapNode<K, V1> removed(K key, int originalHash, int keyHash, int shift) {
        int index;
        int mask = keyHash >>> shift & 0x1F;
        int bitpos = 1 << mask;
        if ((this.dataMap() & bitpos) != 0) {
            index = Node$.MODULE$.indexFrom(this.dataMap(), mask, bitpos);
            if (BoxesRunTime.equals(this.content()[2 * index], key)) {
                if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                    int newDataMap;
                    int n;
                    if (shift == 0) {
                        n = this.dataMap() ^ bitpos;
                    } else {
                        int bitposFrom_mask = keyHash & 0x1F;
                        n = newDataMap = 1 << bitposFrom_mask;
                    }
                    if (index == 0) {
                        return new BitmapIndexedMapNode<K, V>(newDataMap, 0, new Object[]{this.content()[2], this.content()[3]}, new int[]{this.originalHashes()[1]}, 1, Hashing$.MODULE$.improve(this.originalHashes()[1]));
                    }
                    return new BitmapIndexedMapNode<K, V>(newDataMap, 0, new Object[]{this.content()[0], this.content()[1]}, new int[]{this.originalHashes()[0]}, 1, Hashing$.MODULE$.improve(this.originalHashes()[0]));
                }
                return this.copyAndRemoveValue(bitpos, keyHash);
            }
            return this;
        }
        if ((this.nodeMap() & bitpos) != 0) {
            void var2_3;
            void var3_4;
            void newDataMap;
            int index2 = Node$.MODULE$.indexFrom(this.nodeMap(), mask, bitpos);
            Node subNode = this.getNode(index2);
            MapNode subNodeNew = ((MapNode)subNode).removed(newDataMap, index, (int)var3_4, shift + 5);
            if (subNodeNew == subNode) {
                return this;
            }
            int subNodeNewSize = subNodeNew.size();
            if (subNodeNewSize == 1) {
                if (this.size() == ((MapNode)subNode).size()) {
                    return (BitmapIndexedMapNode)subNodeNew;
                }
                return this.copyAndMigrateFromNodeToInline(bitpos, (MapNode<K, V1>)subNode, subNodeNew);
            }
            if (var2_3 > true) {
                void var1_1;
                return this.copyAndSetNode(bitpos, (MapNode<K, V1>)subNode, (MapNode<K, V1>)var1_1);
            }
            return this;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> MapNode<K, V1> mergeTwoKeyValPairs(K key0, V1 value0, int originalHash0, int keyHash0, K key1, V1 value1, int originalHash1, int keyHash1, int shift) {
        void var1_1;
        void var4_4;
        void var3_3;
        void var2_2;
        if (shift >= 32) {
            return new HashCollisionMapNode(originalHash0, keyHash0, Vector$.MODULE$.from((IterableOnce)ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[]{new Tuple2<K, V1>(key0, value0), new Tuple2<K, V1>(key1, value1)})));
        }
        int mask0 = keyHash0 >>> shift & 0x1F;
        int mask1 = keyHash1 >>> shift & 0x1F;
        int newCachedHash = keyHash0 + keyHash1;
        if (mask0 != mask1) {
            int dataMap = 1 << mask0 | 1 << mask1;
            if (mask0 < mask1) {
                return new BitmapIndexedMapNode<K, V>(dataMap, 0, new Object[]{key0, value0, key1, value1}, new int[]{originalHash0, originalHash1}, 2, newCachedHash);
            }
            return new BitmapIndexedMapNode<K, V>(dataMap, 0, new Object[]{key1, value1, key0, value0}, new int[]{originalHash1, originalHash0}, 2, newCachedHash);
        }
        int nodeMap = 1 << mask0;
        MapNode<K, void> node = this.mergeTwoKeyValPairs(key0, var2_2, (int)var3_3, (int)var4_4, key1, value1, originalHash1, keyHash1, shift + 5);
        return new BitmapIndexedMapNode<K, V>(0, nodeMap, new Object[]{node}, Array$.MODULE$.emptyIntArray(), node.size(), var1_1.cachedJavaKeySetHashCode());
    }

    @Override
    public final boolean hasNodes() {
        return this.nodeMap() != 0;
    }

    @Override
    public final int nodeArity() {
        return Integer.bitCount(this.nodeMap());
    }

    @Override
    public final boolean hasPayload() {
        return this.dataMap() != 0;
    }

    @Override
    public final int payloadArity() {
        return Integer.bitCount(this.dataMap());
    }

    /*
     * WARNING - void declaration
     */
    public final int dataIndex(int bitpos) {
        void var1_1;
        return Integer.bitCount(this.dataMap() & var1_1 - true);
    }

    /*
     * WARNING - void declaration
     */
    public final int nodeIndex(int bitpos) {
        void var1_1;
        return Integer.bitCount(this.nodeMap() & var1_1 - true);
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V1> copyAndSetValue(int bitpos, K newKey, V1 newValue) {
        void var3_3;
        void var2_2;
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, ((void)var2_2).length);
        dst[var1_1 + true] = var3_3;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size(), this.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V1> copyAndSetNode(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> newNode) {
        void var3_3;
        void var2_2;
        int idx = this.content().length - 1 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length];
        System.arraycopy(src, 0, dst, 0, src.length);
        dst[var1_1] = newNode;
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), dst, this.originalHashes(), this.size() - oldNode.size() + newNode.size(), this.cachedJavaKeySetHashCode() - var2_2.cachedJavaKeySetHashCode() + var3_3.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V1> copyAndInsertValue(int bitpos, K key, int originalHash, int keyHash, V1 value) {
        void var2_2;
        void var1_1;
        void var3_3;
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        BitmapIndexedMapNode bitmapIndexedMapNode = this;
        int[] dstHashes = bitmapIndexedMapNode.insertElement(bitmapIndexedMapNode.originalHashes(), dataIx, (int)var3_3);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | var1_1, this.nodeMap(), dst, (int[])var2_2, this.size() + 1, this.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    public final BitmapIndexedMapNode<K, V> copyAndRemoveValue(int bitpos, int keyHash) {
        void var2_2;
        void var3_4;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2];
        System.arraycopy(src, 0, dst, 0, idx);
        System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
        BitmapIndexedMapNode bitmapIndexedMapNode = this;
        int[] dstHashes = bitmapIndexedMapNode.removeElement(bitmapIndexedMapNode.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ var1_1, this.nodeMap(), dst, (int[])var3_4, this.size() - 1, this.cachedJavaKeySetHashCode() - var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V> migrateFromInlineToNodeInPlace(int bitpos, int keyHash, MapNode<K, V1> node) {
        void var3_3;
        void var2_2;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        BitmapIndexedMapNode bitmapIndexedMapNode = this;
        int[] dstHashes = bitmapIndexedMapNode.removeElement(bitmapIndexedMapNode.originalHashes(), dataIx);
        BitmapIndexedMapNode bitmapIndexedMapNode2 = this;
        bitmapIndexedMapNode2.dataMap_$eq(bitmapIndexedMapNode2.dataMap() ^ bitpos);
        BitmapIndexedMapNode bitmapIndexedMapNode3 = this;
        bitmapIndexedMapNode3.nodeMap_$eq(bitmapIndexedMapNode3.nodeMap() | var1_1);
        this.content_$eq(dst);
        this.originalHashes_$eq(dstHashes);
        BitmapIndexedMapNode bitmapIndexedMapNode4 = this;
        bitmapIndexedMapNode4.size_$eq(bitmapIndexedMapNode4.size() - 1 + node.size());
        BitmapIndexedMapNode bitmapIndexedMapNode5 = this;
        bitmapIndexedMapNode5.cachedJavaKeySetHashCode_$eq(bitmapIndexedMapNode5.cachedJavaKeySetHashCode() - var2_2 + var3_3.cachedJavaKeySetHashCode());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromInlineToNode(int bitpos, int keyHash, MapNode<K, V1> node) {
        void var3_3;
        void var2_2;
        void var1_1;
        int dataIx = this.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = this.content().length - 2 - this.nodeIndex(bitpos);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        BitmapIndexedMapNode bitmapIndexedMapNode = this;
        int[] dstHashes = bitmapIndexedMapNode.removeElement(bitmapIndexedMapNode.originalHashes(), dataIx);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() ^ bitpos, this.nodeMap() | var1_1, dst, dstHashes, this.size() - 1 + node.size(), this.cachedJavaKeySetHashCode() - var2_2 + var3_3.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    public final <V1> BitmapIndexedMapNode<K, V1> copyAndMigrateFromNodeToInline(int bitpos, MapNode<K, V1> oldNode, MapNode<K, V1> node) {
        void var3_3;
        void var2_2;
        void var1_1;
        int idxOld = this.content().length - 1 - this.nodeIndex(bitpos);
        int dataIxNew = this.dataIndex(bitpos);
        int idxNew = 2 * dataIxNew;
        K key = node.getKey(0);
        V1 value = node.getValue(0);
        Object[] src = this.content();
        Object[] dst = new Object[src.length - 1 + 2];
        System.arraycopy(src, 0, dst, 0, idxNew);
        dst[idxNew] = key;
        dst[idxNew + 1] = value;
        System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
        System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
        int hash = node.getHash(0);
        BitmapIndexedMapNode bitmapIndexedMapNode = this;
        int[] dstHashes = bitmapIndexedMapNode.insertElement(bitmapIndexedMapNode.originalHashes(), dataIxNew, hash);
        return new BitmapIndexedMapNode<K, V>(this.dataMap() | bitpos, this.nodeMap() ^ var1_1, dst, dstHashes, this.size() - oldNode.size() + 1, this.cachedJavaKeySetHashCode() - var2_2.cachedJavaKeySetHashCode() + var3_3.cachedJavaKeySetHashCode());
    }

    @Override
    public final <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.getPayload(i));
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreach(f);
        }
    }

    @Override
    public final <U> void foreachEntry(Function2<K, V, U> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[2 * i], this.content()[2 * i + 1]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachEntry(f);
        }
    }

    @Override
    public final void foreachWithHash(Function3<K, V, Object, BoxedUnit> f) {
        int iN = this.payloadArity();
        for (int i = 0; i < iN; ++i) {
            f.apply(this.content()[2 * i], this.content()[2 * i + 1], this.originalHashes()[i]);
        }
        int jN = this.nodeArity();
        for (int j = 0; j < jN; ++j) {
            ((MapNode)this.getNode(j)).foreachWithHash(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object that) {
        block6: {
            block8: {
                block7: {
                    boolean bl;
                    if (!(that instanceof BitmapIndexedMapNode)) break block6;
                    if (this == (that = (BitmapIndexedMapNode)that)) break block7;
                    if (this.cachedJavaKeySetHashCode() != ((BitmapIndexedMapNode)that).cachedJavaKeySetHashCode() || this.nodeMap() != ((BitmapIndexedMapNode)that).nodeMap() || this.dataMap() != ((BitmapIndexedMapNode)that).dataMap() || this.size() != ((BitmapIndexedMapNode)that).size() || !Arrays.equals(this.originalHashes(), ((BitmapIndexedMapNode)that).originalHashes())) break block8;
                    int n = this.content().length;
                    Object[] deepContentEquality_a2 = ((BitmapIndexedMapNode)that).content();
                    Object[] deepContentEquality_a1 = this.content();
                    if (deepContentEquality_a1 == deepContentEquality_a2) {
                        bl = true;
                    } else {
                        void deepContentEquality_length;
                        boolean deepContentEquality_isEqual = true;
                        for (int deepContentEquality_i = 0; deepContentEquality_isEqual && deepContentEquality_i < deepContentEquality_length; ++deepContentEquality_i) {
                            deepContentEquality_isEqual = BoxesRunTime.equals(deepContentEquality_a1[deepContentEquality_i], deepContentEquality_a2[deepContentEquality_i]);
                        }
                        bl = deepContentEquality_isEqual;
                    }
                    if (!bl) break block8;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("Trie nodes do not support hashing.");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <V1> BitmapIndexedMapNode<K, V1> concat(MapNode<K, V1> that, int shift) {
        if (that instanceof BitmapIndexedMapNode) {
            void var3_4;
            BitmapIndexedMapNode bitmapIndexedMapNode;
            bitmapIndexedMapNode = bitmapIndexedMapNode;
            if (this.size() == 0) {
                return bitmapIndexedMapNode;
            }
            if (bitmapIndexedMapNode.size() == 0 || bitmapIndexedMapNode == this) {
                return this;
            }
            if (bitmapIndexedMapNode.size() == 1) {
                int originalHash = bitmapIndexedMapNode.getHash(0);
                return this.updated((Object)bitmapIndexedMapNode.getKey(0), bitmapIndexedMapNode.getValue(0), originalHash, Hashing$.MODULE$.improve(originalHash), shift, true);
            }
            boolean anyChangesMadeSoFar = false;
            int allMap = this.dataMap() | bitmapIndexedMapNode.dataMap() | this.nodeMap() | bitmapIndexedMapNode.nodeMap();
            int minimumBitPos = Node$.MODULE$.bitposFrom(Integer.numberOfTrailingZeros(allMap));
            int maximumBitPos = Node$.MODULE$.bitposFrom(32 - Integer.numberOfLeadingZeros(allMap) - 1);
            int leftNodeRightNode = 0;
            int leftDataRightNode = 0;
            int leftNodeRightData = 0;
            int leftDataOnly = 0;
            int rightDataOnly = 0;
            int leftNodeOnly = 0;
            int rightNodeOnly = 0;
            int leftDataRightDataMigrateToNode = 0;
            int leftDataRightDataRightOverwrites = 0;
            int dataToNodeMigrationTargets = 0;
            int bitpos = minimumBitPos;
            int leftIdx = 0;
            int rightIdx = 0;
            boolean finished = false;
            while (!finished) {
                if ((bitpos & this.dataMap()) != 0) {
                    if ((bitpos & bitmapIndexedMapNode.dataMap()) != 0) {
                        int leftOriginalHash = this.getHash(leftIdx);
                        if (leftOriginalHash == bitmapIndexedMapNode.getHash(rightIdx) && BoxesRunTime.equals(this.getKey(leftIdx), bitmapIndexedMapNode.getKey(rightIdx))) {
                            leftDataRightDataRightOverwrites |= bitpos;
                        } else {
                            leftDataRightDataMigrateToNode |= bitpos;
                            Node$ node$ = Node$.MODULE$;
                            dataToNodeMigrationTargets |= node$.bitposFrom(node$.maskFrom(Hashing$.MODULE$.improve(leftOriginalHash), shift));
                        }
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedMapNode.nodeMap()) != 0) {
                        leftDataRightNode |= bitpos;
                    } else {
                        leftDataOnly |= bitpos;
                    }
                    ++leftIdx;
                } else if ((bitpos & this.nodeMap()) != 0) {
                    if ((bitpos & bitmapIndexedMapNode.dataMap()) != 0) {
                        leftNodeRightData |= bitpos;
                        ++rightIdx;
                    } else if ((bitpos & bitmapIndexedMapNode.nodeMap()) != 0) {
                        leftNodeRightNode |= bitpos;
                    } else {
                        leftNodeOnly |= bitpos;
                    }
                } else if ((bitpos & bitmapIndexedMapNode.dataMap()) != 0) {
                    rightDataOnly |= bitpos;
                    ++rightIdx;
                } else if ((bitpos & bitmapIndexedMapNode.nodeMap()) != 0) {
                    rightNodeOnly |= bitpos;
                }
                if (bitpos == maximumBitPos) {
                    finished = true;
                    continue;
                }
                bitpos <<= 1;
            }
            int newDataMap = leftDataOnly | rightDataOnly | leftDataRightDataRightOverwrites;
            int newNodeMap = leftNodeRightNode | leftDataRightNode | leftNodeRightData | leftNodeOnly | rightNodeOnly | dataToNodeMigrationTargets;
            if (newDataMap == (rightDataOnly | leftDataRightDataRightOverwrites) && newNodeMap == rightNodeOnly) {
                return bitmapIndexedMapNode;
            }
            int newDataSize = Integer.bitCount(newDataMap);
            int newContentSize = 2 * newDataSize + Integer.bitCount(newNodeMap);
            Object[] newContent = new Object[newContentSize];
            int[] newOriginalHashes = new int[newDataSize];
            int newSize = 0;
            int newCachedHashCode = 0;
            int leftDataIdx = 0;
            int rightDataIdx = 0;
            int leftNodeIdx = 0;
            int rightNodeIdx = 0;
            int nextShift = shift + 5;
            int compressedDataIdx = 0;
            int compressedNodeIdx = 0;
            int bitpos2 = minimumBitPos;
            boolean finished2 = false;
            while (!finished2) {
                if ((bitpos2 & leftNodeRightNode) != 0) {
                    MapNode newNode;
                    Node rightNode = bitmapIndexedMapNode.getNode(rightNodeIdx);
                    if (rightNode != (newNode = ((MapNode)this.getNode(leftNodeIdx)).concat(rightNode, nextShift))) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftNodeIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightNode) != 0) {
                    int leftImproved;
                    int leftOriginalHash;
                    V leftValue;
                    K leftKey;
                    Node n = bitmapIndexedMapNode.getNode(rightNodeIdx);
                    MapNode<K, V> updated = ((MapNode)n).updated(leftKey = this.getKey(leftDataIdx), leftValue = this.getValue(leftDataIdx), leftOriginalHash = this.getHash(leftDataIdx), leftImproved = Hashing$.MODULE$.improve(leftOriginalHash), nextShift, false);
                    if (updated != n) {
                        anyChangesMadeSoFar = true;
                    }
                    newContent[newContentSize - compressedNodeIdx - 1] = updated;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    ++leftDataIdx;
                    newSize += updated.size();
                    newCachedHashCode += updated.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftNodeRightData) != 0) {
                    MapNode<K, V> newNode;
                    anyChangesMadeSoFar = true;
                    int rightOriginalHash = bitmapIndexedMapNode.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = ((MapNode)this.getNode(leftNodeIdx)).updated(bitmapIndexedMapNode.getKey(rightDataIdx), bitmapIndexedMapNode.getValue(rightDataIdx), bitmapIndexedMapNode.getHash(rightDataIdx), Hashing$.MODULE$.improve(rightOriginalHash), nextShift, true);
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    int originalHash = this.originalHashes()[leftDataIdx];
                    newContent[2 * compressedDataIdx] = this.getKey(leftDataIdx);
                    newContent[2 * compressedDataIdx + 1] = this.getValue(leftDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++leftDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & rightDataOnly) != 0) {
                    int originalHash = bitmapIndexedMapNode.originalHashes()[rightDataIdx];
                    newContent[2 * compressedDataIdx] = bitmapIndexedMapNode.getKey(rightDataIdx);
                    newContent[2 * compressedDataIdx + 1] = bitmapIndexedMapNode.getValue(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                } else if ((bitpos2 & leftNodeOnly) != 0) {
                    anyChangesMadeSoFar = true;
                    Node newNode = this.getNode(leftNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++leftNodeIdx;
                    newSize += ((MapNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & rightNodeOnly) != 0) {
                    Node newNode = bitmapIndexedMapNode.getNode(rightNodeIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode;
                    ++compressedNodeIdx;
                    ++rightNodeIdx;
                    newSize += ((MapNode)newNode).size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataMigrateToNode) != 0) {
                    MapNode<K, V> newNode;
                    anyChangesMadeSoFar = true;
                    int leftOriginalHash = this.getHash(leftDataIdx);
                    int rightOriginalHash = bitmapIndexedMapNode.getHash(rightDataIdx);
                    newContent[newContentSize - compressedNodeIdx - 1] = newNode = bitmapIndexedMapNode.mergeTwoKeyValPairs(this.getKey(leftDataIdx), this.getValue(leftDataIdx), leftOriginalHash, Hashing$.MODULE$.improve(leftOriginalHash), bitmapIndexedMapNode.getKey(rightDataIdx), bitmapIndexedMapNode.getValue(rightDataIdx), rightOriginalHash, Hashing$.MODULE$.improve(rightOriginalHash), nextShift);
                    ++compressedNodeIdx;
                    ++leftDataIdx;
                    ++rightDataIdx;
                    newSize += newNode.size();
                    newCachedHashCode += newNode.cachedJavaKeySetHashCode();
                } else if ((bitpos2 & leftDataRightDataRightOverwrites) != 0) {
                    int originalHash = bitmapIndexedMapNode.originalHashes()[rightDataIdx];
                    newContent[2 * compressedDataIdx] = bitmapIndexedMapNode.getKey(rightDataIdx);
                    newContent[2 * compressedDataIdx + 1] = bitmapIndexedMapNode.getValue(rightDataIdx);
                    newOriginalHashes[compressedDataIdx] = originalHash;
                    ++compressedDataIdx;
                    ++rightDataIdx;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(originalHash);
                    ++leftDataIdx;
                }
                if (bitpos2 == maximumBitPos) {
                    finished2 = true;
                    continue;
                }
                bitpos2 <<= 1;
            }
            if (var3_4 != false) {
                return new BitmapIndexedMapNode<K, V>(newDataMap, newNodeMap, newContent, newOriginalHashes, newSize, newCachedHashCode);
            }
            return bitmapIndexedMapNode;
        }
        throw new UnsupportedOperationException("Cannot concatenate a HashCollisionMapNode with a BitmapIndexedMapNode");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedMapNode<K, V> copy() {
        void var1_1;
        Object[] contentClone = (Object[])this.content().clone();
        int contentLength = contentClone.length;
        for (int i = Integer.bitCount(this.dataMap()) << 1; i < contentLength; ++i) {
            contentClone[i] = ((MapNode)contentClone[i]).copy();
        }
        return new BitmapIndexedMapNode<K, V>(this.dataMap(), this.nodeMap(), (Object[])var1_1, (int[])this.originalHashes().clone(), this.size(), this.cachedJavaKeySetHashCode());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitmapIndexedMapNode<K, V> filterImpl(Function1<Tuple2<K, V>, Object> pred, boolean flipped) {
        void var1_4;
        void var3_10;
        if (this.size() == 0) {
            return this;
        }
        if (this.size() == 1) {
            if (BoxesRunTime.unboxToBoolean(pred.apply(this.getPayload(0))) != flipped) {
                return this;
            }
            return MapNode$.MODULE$.empty();
        }
        if (this.nodeMap() == 0) {
            void i;
            int minimumIndex = Integer.numberOfTrailingZeros(this.dataMap());
            int maximumIndex = 32 - Integer.numberOfLeadingZeros(this.dataMap());
            int newDataMap = 0;
            int newCachedHashCode = 0;
            int dataIndex = 0;
            while (i < maximumIndex) {
                int bitpos = 1 << i;
                if ((bitpos & this.dataMap()) != 0) {
                    Tuple2<K, V> payload = this.getPayload(dataIndex);
                    if (BoxesRunTime.unboxToBoolean(pred.apply(payload)) != flipped) {
                        newDataMap |= bitpos;
                        newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                    }
                    ++dataIndex;
                }
                ++i;
            }
            if (newDataMap == 0) {
                return MapNode$.MODULE$.empty();
            }
            if (newDataMap == this.dataMap()) {
                return this;
            }
            int newSize2 = Integer.bitCount(newDataMap);
            Object[] newContent = new Object[newSize2 << 1];
            int[] newOriginalHashCodes = new int[newSize2];
            int newMaximumIndex = 32 - Integer.numberOfLeadingZeros(newDataMap);
            int newDataIndex = 0;
            for (int j = Integer.numberOfTrailingZeros(newDataMap); j < newMaximumIndex; ++j) {
                int bitpos = 1 << j;
                if ((bitpos & newDataMap) == 0) continue;
                int oldIndex = Integer.bitCount(this.dataMap() & bitpos - 1);
                newContent[newDataIndex << 1] = this.content()[oldIndex << 1];
                newContent[(newDataIndex << 1) + 1] = this.content()[(oldIndex << 1) + 1];
                newOriginalHashCodes[newDataIndex] = this.originalHashes()[oldIndex];
                ++newDataIndex;
            }
            return new BitmapIndexedMapNode<K, V>(newDataMap, 0, newContent, newOriginalHashCodes, newSize2, newCachedHashCode);
        }
        int allMap = this.dataMap() | this.nodeMap();
        int minimumIndex = Integer.numberOfTrailingZeros(allMap);
        int maximumIndex = 32 - Integer.numberOfLeadingZeros(allMap);
        int oldDataPassThrough = 0;
        int nodeMigrateToDataTargetMap = 0;
        AbstractBuffer nodesToMigrateToData = null;
        int nodesToPassThroughMap = 0;
        int mapOfNewNodes = 0;
        Object newNodes = null;
        int newDataMap = 0;
        int newNodeMap = 0;
        int newSize = 0;
        int newCachedHashCode = 0;
        int dataIndex = 0;
        int nodeIndex = 0;
        for (int i = minimumIndex; i < maximumIndex; ++i) {
            void newContent;
            void newSize2;
            int bitpos = 1 << i;
            if ((bitpos & this.dataMap()) != 0) {
                Tuple2<K, V> payload = this.getPayload(dataIndex);
                if (BoxesRunTime.unboxToBoolean(newSize2.apply(payload)) != newContent) {
                    newDataMap |= bitpos;
                    oldDataPassThrough |= bitpos;
                    ++newSize;
                    newCachedHashCode += Hashing$.MODULE$.improve(this.originalHashes()[dataIndex]);
                }
                ++dataIndex;
                continue;
            }
            if ((bitpos & this.nodeMap()) == 0) continue;
            Node oldSubNode = this.getNode(nodeIndex);
            MapNode newSubNode = ((MapNode)oldSubNode).filterImpl(newSize2, (boolean)newContent);
            newSize += newSubNode.size();
            newCachedHashCode += newSubNode.cachedJavaKeySetHashCode();
            if (newSubNode.size() > 1) {
                newNodeMap |= bitpos;
                if (oldSubNode == newSubNode) {
                    nodesToPassThroughMap |= bitpos;
                } else {
                    mapOfNewNodes |= bitpos;
                    if (newNodes == null) {
                        newNodes = Queue$.MODULE$.empty();
                    }
                    ((AbstractBuffer)newNodes).$plus$eq(newSubNode);
                }
            } else if (newSubNode.size() == 1) {
                newDataMap |= bitpos;
                nodeMigrateToDataTargetMap |= bitpos;
                if (nodesToMigrateToData == null) {
                    nodesToMigrateToData = (Queue)IterableFactory.apply$(Queue$.MODULE$, Nil$.MODULE$);
                }
                nodesToMigrateToData.$plus$eq(newSubNode);
            }
            ++nodeIndex;
        }
        if (newSize == 0) {
            return MapNode$.MODULE$.empty();
        }
        if (newSize == this.size()) {
            return this;
        }
        int newDataSize = Integer.bitCount(newDataMap);
        int newContentSize = 2 * newDataSize + Integer.bitCount(newNodeMap);
        Object[] newContent = new Object[newContentSize];
        int[] newOriginalHashes = new int[newDataSize];
        int newAllMap = newDataMap | newNodeMap;
        int maxIndex = 32 - Integer.numberOfLeadingZeros(newAllMap);
        int oldDataIndex = 0;
        int oldNodeIndex = 0;
        int newDataIndex = 0;
        int newNodeIndex = 0;
        for (int i = minimumIndex; i < maxIndex; ++i) {
            void var20_36;
            int bitpos = 1 << i;
            if ((bitpos & oldDataPassThrough) != 0) {
                newContent[newDataIndex << 1] = this.content()[2 * oldDataIndex];
                newContent[(newDataIndex << 1) + 1] = this.content()[2 * oldDataIndex + 1];
                newOriginalHashes[newDataIndex] = this.originalHashes()[oldDataIndex];
                ++newDataIndex;
                ++oldDataIndex;
                continue;
            }
            if ((bitpos & nodesToPassThroughMap) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = this.getNode(oldNodeIndex);
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((bitpos & nodeMigrateToDataTargetMap) != 0) {
                MapNode node = (MapNode)((Queue)nodesToMigrateToData).dequeue();
                newContent[2 * newDataIndex] = node.getKey(0);
                newContent[2 * newDataIndex + 1] = node.getValue(0);
                newOriginalHashes[newDataIndex] = node.getHash(0);
                ++newDataIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((var20_36 & mapOfNewNodes) != 0) {
                newContent[newContentSize - newNodeIndex - 1] = ((Queue)newNodes).dequeue();
                ++newNodeIndex;
                ++oldNodeIndex;
                continue;
            }
            if ((var20_36 & this.dataMap()) != 0) {
                ++oldDataIndex;
                continue;
            }
            if ((var20_36 & this.nodeMap()) == 0) continue;
            ++oldNodeIndex;
        }
        return new BitmapIndexedMapNode<K, V>(newDataMap, newNodeMap, (Object[])var3_10, (int[])var1_4, newSize, newCachedHashCode);
    }

    /*
     * WARNING - void declaration
     */
    public BitmapIndexedMapNode(int dataMap, int nodeMap, Object[] content, int[] originalHashes, int size, int cachedJavaKeySetHashCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dataMap = var1_1;
        this.nodeMap = var2_2;
        this.content = var3_3;
        this.originalHashes = originalHashes;
        this.size = size;
        this.cachedJavaKeySetHashCode = cachedJavaKeySetHashCode;
        Statics.releaseFence();
    }
}

