/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.lz4;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import net.jpountz.lz4.LZ4FrameOutputStream;

public class LZ4Deflater {
    private boolean isFinished = false;
    private boolean needsInput = true;
    LZ4FrameOutputStream lzfo;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private byte[] buffer;
    byte[] trailingBytes;
    private int off;
    private int len;
    private boolean isTrailingBytesTobeProcessed = false;

    public void setInput(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.off = n2;
        this.len = n3;
    }

    public int deflate(byte[] byArray, int n2, int n3) throws Exception {
        Object[] objectArray;
        if (this.lzfo == null) {
            objectArray = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE, LZ4FrameOutputStream.FLG.Bits.CONTENT_CHECKSUM};
            this.lzfo = new LZ4FrameOutputStream((OutputStream)this.baos, LZ4FrameOutputStream.BLOCKSIZE.SIZE_256KB, -1L, (LZ4FrameOutputStream.FLG.Bits[])objectArray);
        }
        if (!this.finished()) {
            this.lzfo.write(this.buffer, this.off, this.len);
            this.lzfo.flush();
            objectArray = this.baos.toByteArray();
            this.baos.reset();
            if (objectArray.length < byArray.length) {
                System.arraycopy(objectArray, 0, byArray, n2, objectArray.length);
                return objectArray.length;
            }
            System.arraycopy(objectArray, n2, byArray, n2, byArray.length);
            return byArray.length;
        }
        if (byArray.length >= n2 + 8) {
            return this.processFooter(byArray, n2);
        }
        this.isTrailingBytesTobeProcessed = true;
        int n4 = byArray.length - n2;
        byte[] byArray2 = this.baos.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n2, n4);
        int n5 = byArray2.length - n4;
        this.trailingBytes = new byte[n5];
        System.arraycopy(byArray2, n4, this.trailingBytes, 0, n5);
        return n4;
    }

    public boolean isTrailingBytesTobeProcessed() {
        return this.isTrailingBytesTobeProcessed;
    }

    public byte[] getTrailingBytes() {
        this.isTrailingBytesTobeProcessed = false;
        return this.trailingBytes;
    }

    private int processFooter(byte[] byArray, int n2) throws IOException {
        this.baos.flush();
        byte[] byArray2 = this.baos.toByteArray();
        int n3 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return n3;
    }

    public boolean finished() {
        return this.isFinished;
    }

    public boolean allFinished() {
        return this.isFinished && !this.isTrailingBytesTobeProcessed;
    }

    public boolean needsInput() {
        return this.needsInput;
    }

    public void finish() {
        try {
            if (this.lzfo != null) {
                this.lzfo.flush();
                this.lzfo.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.isFinished = true;
    }

    public void end() {
        try {
            if (this.lzfo != null) {
                this.lzfo.flush();
                this.lzfo.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.out.println("\n\tUsage: java -cp db2jcc4.jar com.ibm.db2.jcc.lz4.LZ4Deflater <inputFilePath> <outputFilePath>");
        } else {
            File file = new File(stringArray[0]);
            File file2 = new File(stringArray[1]);
            LZ4Deflater lZ4Deflater = new LZ4Deflater();
            lZ4Deflater.deflate(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deflate(File file, File file2) throws Exception {
        System.out.println();
        System.out.println("\tCompressing using lz4-java");
        byte[] byArray = Files.readAllBytes(file.toPath());
        try (OutputStream outputStream = null;){
            outputStream = new FileOutputStream(file2);
            LZ4FrameOutputStream.FLG.Bits[] bitsArray = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE, LZ4FrameOutputStream.FLG.Bits.CONTENT_CHECKSUM};
            LZ4FrameOutputStream lZ4FrameOutputStream = new LZ4FrameOutputStream(outputStream, LZ4FrameOutputStream.BLOCKSIZE.SIZE_256KB, byArray.length, bitsArray);
            lZ4FrameOutputStream.write(byArray, 0, byArray.length);
            lZ4FrameOutputStream.flush();
            lZ4FrameOutputStream.close();
        }
        System.out.println();
        System.out.println("\tSuccessfully compressed " + file.getName() + " contents to " + file2.getName());
    }
}

