/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.replication.fluent;

import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.core.ServerVersion;
import com.amazon.redshift.replication.fluent.ChainedCommonCreateSlotBuilder;
import com.amazon.redshift.util.GT;
import java.sql.SQLFeatureNotSupportedException;

public abstract class AbstractCreateSlotBuilder<T extends ChainedCommonCreateSlotBuilder<T>>
implements ChainedCommonCreateSlotBuilder<T> {
    protected String slotName;
    protected boolean temporaryOption = false;
    protected BaseConnection connection;

    protected AbstractCreateSlotBuilder(BaseConnection connection) {
        this.connection = connection;
    }

    protected abstract T self();

    @Override
    public T withSlotName(String slotName) {
        this.slotName = slotName;
        return this.self();
    }

    @Override
    public T withTemporaryOption() throws SQLFeatureNotSupportedException {
        if (!this.connection.haveMinimumServerVersion(ServerVersion.v10)) {
            throw new SQLFeatureNotSupportedException(GT.tr("Server does not support temporary replication slots", new Object[0]));
        }
        this.temporaryOption = true;
        return this.self();
    }
}

