/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.mpx.MPXJDateFormat;
import net.sf.mpxj.mpx.MPXJNumberFormat;
import net.sf.mpxj.mpx.MPXJTimeFormat;

public final class MPXJFormats {
    private final Locale m_locale;
    private final String m_nullText;
    private final ProjectFile m_projectFile;
    private final MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private final MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private final MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private final MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private final MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String nullText, ProjectFile file) {
        this.m_locale = locale;
        this.m_nullText = nullText;
        this.m_projectFile = file;
        this.update();
    }

    public void update() {
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        char decimalSeparator = properties.getDecimalSeparator();
        char thousandsSeparator = properties.getThousandsSeparator();
        this.updateNumericFormats(decimalSeparator, thousandsSeparator);
        this.updateCurrencyFormats(properties, decimalSeparator, thousandsSeparator);
        this.updateDateTimeFormats(properties);
    }

    private void updateNumericFormats(char decimalSeparator, char thousandsSeparator) {
        this.m_unitsDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_decimalFormat.applyPattern("0.00#", null, decimalSeparator, thousandsSeparator);
        this.m_durationDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, decimalSeparator, thousandsSeparator);
    }

    private void updateCurrencyFormats(ProjectProperties properties, char decimalSeparator, char thousandsSeparator) {
        String noSymbolSecondaryPattern;
        String noSymbolPrimaryPattern;
        String secondaryPattern;
        String prefix = "";
        String suffix = "";
        String currencySymbol = this.quoteFormatCharacters(properties.getCurrencySymbol());
        switch (properties.getSymbolPosition()) {
            case AFTER: {
                suffix = currencySymbol;
                break;
            }
            case BEFORE: {
                prefix = currencySymbol;
                break;
            }
            case AFTER_WITH_SPACE: {
                suffix = " " + currencySymbol;
                break;
            }
            case BEFORE_WITH_SPACE: {
                prefix = currencySymbol + " ";
            }
        }
        StringBuilder pattern = new StringBuilder(prefix);
        pattern.append("#0");
        int digits = properties.getCurrencyDigits();
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        pattern.append(suffix);
        String primaryPattern = pattern.toString();
        String[] alternativePatterns = new String[7];
        alternativePatterns[0] = primaryPattern + ";(" + primaryPattern + ")";
        pattern.insert(prefix.length(), "#,#");
        alternativePatterns[1] = secondaryPattern = pattern.toString();
        alternativePatterns[2] = secondaryPattern + ";(" + secondaryPattern + ")";
        pattern.setLength(0);
        pattern.append("#0");
        if (digits > 0) {
            pattern.append('.');
            for (int i = 0; i < digits; ++i) {
                pattern.append("0");
            }
        }
        alternativePatterns[3] = noSymbolPrimaryPattern = pattern.toString();
        alternativePatterns[4] = noSymbolPrimaryPattern + ";(" + noSymbolPrimaryPattern + ")";
        pattern.insert(0, "#,#");
        alternativePatterns[5] = noSymbolSecondaryPattern = pattern.toString();
        alternativePatterns[6] = noSymbolSecondaryPattern + ";(" + noSymbolSecondaryPattern + ")";
        this.m_currencyFormat.applyPattern(primaryPattern, alternativePatterns, decimalSeparator, thousandsSeparator);
    }

    private String quoteFormatCharacters(String literal) {
        StringBuilder sb = new StringBuilder();
        int length = literal.length();
        block3: for (int loop = 0; loop < length; ++loop) {
            char c = literal.charAt(loop);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    sb.append("'");
                    sb.append(c);
                    sb.append("'");
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private void updateDateTimeFormats(ProjectProperties properties) {
        String[] timePatterns = this.getTimePatterns(properties);
        String[] datePatterns = this.getDatePatterns(properties);
        String[] dateTimePatterns = this.getDateTimePatterns(properties, timePatterns);
        this.m_dateTimeFormat.applyPatterns(dateTimePatterns);
        this.m_dateFormat.applyPatterns(datePatterns);
        this.m_timeFormat.applyPatterns(timePatterns);
        this.m_dateTimeFormat.setLocale(this.m_locale);
        this.m_dateFormat.setLocale(this.m_locale);
        this.m_dateTimeFormat.setNullText(this.m_nullText);
        this.m_dateFormat.setNullText(this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(properties.getAMText(), properties.getPMText());
        this.m_timeFormat.setAmPmText(properties.getAMText(), properties.getPMText());
    }

    private String[] getDatePatterns(ProjectProperties properties) {
        String pattern = "";
        char datesep = properties.getDateSeparator();
        DateOrder dateOrder = properties.getDateOrder();
        switch (dateOrder) {
            case DMY: {
                pattern = "dd" + datesep + "MM" + datesep + "yy";
                break;
            }
            case MDY: {
                pattern = "MM" + datesep + "dd" + datesep + "yy";
                break;
            }
            case YMD: {
                pattern = "yy" + datesep + "MM" + datesep + "dd";
            }
        }
        return new String[]{pattern};
    }

    private String[] getDateTimePatterns(ProjectProperties properties, String[] timePatterns) {
        ArrayList<String> patterns = new ArrayList<String>();
        char datesep = properties.getDateSeparator();
        DateOrder dateOrder = properties.getDateOrder();
        block0 : switch (properties.getDateFormat()) {
            case DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.addAll(this.generateDateTimePatterns("dd" + datesep + "MM" + datesep + "yy", timePatterns));
                        break;
                    }
                    case MDY: {
                        patterns.addAll(this.generateDateTimePatterns("MM" + datesep + "dd" + datesep + "yy", timePatterns));
                        break;
                    }
                    case YMD: {
                        patterns.addAll(this.generateDateTimePatterns("yy" + datesep + "MM" + datesep + "dd", timePatterns));
                    }
                }
                break;
            }
            case DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        patterns.add("MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        patterns.add("yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.addAll(this.generateDateTimePatterns("dd MMMMM yyyy", timePatterns));
                        break;
                    }
                    case MDY: {
                        patterns.addAll(this.generateDateTimePatterns("MMMMM dd yyyy", timePatterns));
                        break;
                    }
                    case YMD: {
                        patterns.addAll(this.generateDateTimePatterns("yyyy MMMMM dd", timePatterns));
                    }
                }
                break;
            }
            case DD_MMMMM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd MMMMM yyyy");
                        break;
                    }
                    case MDY: {
                        patterns.add("MMMMM dd yyyy");
                        break;
                    }
                    case YMD: {
                        patterns.add("yyyy MMMMM dd");
                    }
                }
                break;
            }
            case DD_MMM_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.addAll(this.generateDateTimePatterns("dd MMM", timePatterns));
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.addAll(this.generateDateTimePatterns("MMM dd", timePatterns));
                    }
                }
                break;
            }
            case DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        patterns.add("MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        patterns.add("''yy MMM dd");
                    }
                }
                break;
            }
            case DD_MMMMM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd MMMMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.add("MMMMM dd");
                    }
                }
                break;
            }
            case DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.add("MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM_YY_HH_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.addAll(this.generateDateTimePatterns("EEE dd" + datesep + "MM" + datesep + "yy", timePatterns));
                        break;
                    }
                    case MDY: {
                        patterns.addAll(this.generateDateTimePatterns("EEE MM" + datesep + "dd" + datesep + "yy", timePatterns));
                        break;
                    }
                    case YMD: {
                        patterns.addAll(this.generateDateTimePatterns("EEE yy" + datesep + "MM" + datesep + "dd", timePatterns));
                    }
                }
                break;
            }
            case EEE_DD_MM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("EEE dd" + datesep + "MM" + datesep + "yy");
                        break;
                    }
                    case MDY: {
                        patterns.add("EEE MM" + datesep + "dd" + datesep + "yy");
                        break;
                    }
                    case YMD: {
                        patterns.add("EEE yy" + datesep + "MM" + datesep + "dd");
                    }
                }
                break;
            }
            case EEE_DD_MMM_YY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("EEE dd MMM ''yy");
                        break;
                    }
                    case MDY: {
                        patterns.add("EEE MMM dd ''yy");
                        break;
                    }
                    case YMD: {
                        patterns.add("EEE ''yy MMM dd");
                    }
                }
                break;
            }
            case EEE_HH_MM: {
                patterns.addAll(this.generateDateTimePatterns("EEE ", timePatterns));
                break;
            }
            case DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd" + datesep + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.add("MM" + datesep + "dd");
                    }
                }
                break;
            }
            case DD: {
                patterns.add("dd");
                break;
            }
            case HH_MM: {
                patterns.addAll(Arrays.asList(timePatterns));
                break;
            }
            case EEE_DD_MMM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("EEE dd MMM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.add("EEE MMM dd");
                    }
                }
                break;
            }
            case EEE_DD_MM: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("EEE dd" + datesep + "MM");
                        break;
                    }
                    case MDY: 
                    case YMD: {
                        patterns.add("EEE MM" + datesep + "dd");
                    }
                }
                break;
            }
            case EEE_DD: {
                patterns.add("EEE dd");
                break;
            }
            case DD_WWW: {
                patterns.add("F" + datesep + "'W'ww");
                break;
            }
            case DD_WWW_YY_HH_MM: {
                patterns.addAll(this.generateDateTimePatterns("F" + datesep + "'W'ww" + datesep + "yy", timePatterns));
                break;
            }
            case DD_MM_YYYY: {
                switch (dateOrder) {
                    case DMY: {
                        patterns.add("dd" + datesep + "MM" + datesep + "yyyy");
                        break block0;
                    }
                    case MDY: {
                        patterns.add("MM" + datesep + "dd" + datesep + "yyyy");
                        break block0;
                    }
                    case YMD: {
                        patterns.add("yyyy" + datesep + "MM" + datesep + "dd");
                    }
                }
            }
        }
        return patterns.toArray(new String[0]);
    }

    private List<String> generateDateTimePatterns(String datePattern, String[] timePatterns) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String timePattern : timePatterns) {
            patterns.add(datePattern + " " + timePattern);
        }
        patterns.add(datePattern);
        return patterns;
    }

    private String[] getTimePatterns(ProjectProperties properties) {
        char timesep = properties.getTimeSeparator();
        ProjectTimeFormat format = properties.getTimeFormat();
        String[] result = format == null || format == ProjectTimeFormat.TWELVE_HOUR ? new String[]{"hh" + timesep + "mm a", "hh" + timesep + "mma"} : new String[]{"HH" + timesep + "mm", "HH"};
        return result;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }

    public String getNullText() {
        return this.m_nullText;
    }
}

