/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.util.deparser.AbstractDeParser;

public class SetStatementDeParser
extends AbstractDeParser<SetStatement> {
    private ExpressionVisitor<StringBuilder> expressionVisitor;

    public SetStatementDeParser(ExpressionVisitor<StringBuilder> expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(SetStatement set) {
        this.builder.append("SET ");
        if (set.getEffectParameter() != null) {
            this.builder.append(set.getEffectParameter()).append(" ");
        }
        for (int i = 0; i < set.getCount(); ++i) {
            if (i > 0) {
                this.builder.append(", ");
            }
            this.builder.append(set.getName(i));
            if (set.isUseEqual(i)) {
                this.builder.append(" =");
            }
            this.builder.append(" ");
            List<Expression> expressions = set.getExpressions(i);
            for (int j = 0; j < expressions.size(); ++j) {
                if (j > 0) {
                    this.builder.append(", ");
                }
                expressions.get(j).accept(this.expressionVisitor, null);
            }
        }
    }

    public ExpressionVisitor<StringBuilder> getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor<StringBuilder> visitor) {
        this.expressionVisitor = visitor;
    }
}

