/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.transaction.generated;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKeyJsonConverter;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValueJsonConverter;

public class CoordinatorRecordJsonConverters {
    public static JsonNode writeRecordKeyAsJson(ApiMessage key) {
        switch (key.apiKey()) {
            case 0: {
                return TransactionLogKeyJsonConverter.write((TransactionLogKey)key, (short)0);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + key.apiKey());
    }

    public static JsonNode writeRecordValueAsJson(ApiMessage value, short version) {
        switch (value.apiKey()) {
            case 0: {
                return TransactionLogValueJsonConverter.write((TransactionLogValue)value, version);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + value.apiKey());
    }

    public static ApiMessage readRecordKeyFromJson(JsonNode json, short apiKey) {
        switch (apiKey) {
            case 0: {
                return TransactionLogKeyJsonConverter.read(json, (short)0);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + apiKey);
    }

    public static ApiMessage readRecordValueFromJson(JsonNode json, short apiKey, short version) {
        switch (apiKey) {
            case 0: {
                return TransactionLogValueJsonConverter.read(json, version);
            }
        }
        throw new UnsupportedVersionException("Unknown record id " + apiKey);
    }
}

