/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.jws.JWAIdentifier;
import java.security.cert.CertPath;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JWSHeader {
    private final JWAIdentifier alg;
    private final CertPath x5c;

    public JWSHeader(@JsonProperty(value="alg") @Nullable JWAIdentifier alg, @JsonProperty(value="x5c") @Nullable CertPath x5c) {
        this.alg = alg;
        this.x5c = x5c;
    }

    @Nullable
    public JWAIdentifier getAlg() {
        return this.alg;
    }

    @Nullable
    public CertPath getX5c() {
        return this.x5c;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWSHeader jwsHeader = (JWSHeader)o;
        return this.alg == jwsHeader.alg && Objects.equals(this.x5c, jwsHeader.x5c);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alg, this.x5c});
    }

    public String toString() {
        return "JWSHeader(alg=" + String.valueOf((Object)this.alg) + ", x5c=" + String.valueOf(this.x5c) + ")";
    }
}

