/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import jakarta.ws.rs.BadRequestException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

public class ReservedCharValidator {
    protected static final Logger logger = Logger.getLogger(ReservedCharValidator.class);
    private static final Pattern RESERVED_CHARS_PATTERN = Pattern.compile("[:/?#@!$&()*+,;=\\[\\]\\\\]");
    private static final Pattern RESERVED_CHARS_LOCALES_PATTERN = Pattern.compile("[:/?#@!$&()*+,;=\\[\\]\\\\{}%]");

    private ReservedCharValidator() {
    }

    public static void validate(String str, Pattern pattern) {
        ReservedCharValidator.validate(str, pattern, null);
    }

    public static void validate(String str, Pattern pattern, String message) throws ReservedCharException {
        if (str == null) {
            return;
        }
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            if (message == null) {
                message = "Character '" + matcher.group() + "' not allowed.";
            }
            logger.warn(message);
            throw new ReservedCharException((String)message);
        }
    }

    public static void validateNoSpace(String str) {
        ReservedCharValidator.validate(str, Pattern.compile("\\s"), "Empty Space not allowed.");
        ReservedCharValidator.validate(str, RESERVED_CHARS_PATTERN);
    }

    public static void validate(String str) {
        ReservedCharValidator.validate(str, RESERVED_CHARS_PATTERN);
    }

    public static void validateLocales(Iterable<String> strIterable) {
        if (strIterable == null) {
            return;
        }
        for (String str : strIterable) {
            ReservedCharValidator.validate(str, RESERVED_CHARS_LOCALES_PATTERN);
        }
    }

    public static void validateSecurityHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ReservedCharValidator.validate(entry.getKey(), Pattern.compile("\\n"), "Newline not allowed.");
            ReservedCharValidator.validate(entry.getValue(), Pattern.compile("\\n"), "Newline not allowed.");
        }
    }

    public static class ReservedCharException
    extends BadRequestException {
        ReservedCharException(String msg) {
            super(msg);
        }
    }
}

