/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Collections;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProviderFactory;
import org.keycloak.services.clientpolicy.executor.DownscopeAssertionGrantEnforcerExecutor;

public class DownscopeAssertionGrantEnforcerExecutorFactory
implements ClientPolicyExecutorProviderFactory {
    public static final String PROVIDER_ID = "downscope-assertion-grant-enforcer";

    public ClientPolicyExecutorProvider create(KeycloakSession session) {
        return new DownscopeAssertionGrantEnforcerExecutor(session);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "It ensures that the scopes in the final access token are limited to the ones already present in the JWT assertion passed.\nFor the moment, the executor applies to certain grants where some initial token/assertion is passed (for example\nsubject_token in case of Standard Token Exchange grant). The limitation is done over the scopes that are\npresent in the initial token/assertion, returning an error if any extra scope is requested.\n";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

