/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.permission.evaluator;

import java.util.Collection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.permission.ResourcePermission;
import org.keycloak.authorization.permission.evaluator.IterablePermissionEvaluator;
import org.keycloak.authorization.permission.evaluator.PermissionEvaluator;
import org.keycloak.authorization.permission.evaluator.UnboundedPermissionEvaluator;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;

public final class Evaluators {
    private final AuthorizationProvider authorizationProvider;

    public Evaluators(AuthorizationProvider authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public PermissionEvaluator from(Collection<ResourcePermission> permissions, EvaluationContext evaluationContext) {
        return new IterablePermissionEvaluator(permissions.iterator(), evaluationContext, this.authorizationProvider);
    }

    public PermissionEvaluator from(Collection<ResourcePermission> permissions, ResourceServer resourceServer, EvaluationContext evaluationContext) {
        return new IterablePermissionEvaluator(permissions.iterator(), resourceServer, evaluationContext, this.authorizationProvider);
    }

    public PermissionEvaluator from(EvaluationContext evaluationContext, ResourceServer resourceServer, AuthorizationRequest request) {
        return new UnboundedPermissionEvaluator(evaluationContext, this.authorizationProvider, resourceServer, request);
    }
}

