/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.xsite.irac.IracManager;

public class IracTombstoneRemoteSiteCheckCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 38;
    private List<Object> keys;

    public IracTombstoneRemoteSiteCheckCommand() {
        super(null);
    }

    public IracTombstoneRemoteSiteCheckCommand(ByteString cacheName) {
        super(cacheName);
    }

    public IracTombstoneRemoteSiteCheckCommand(ByteString cacheName, List<Object> keys) {
        super(cacheName);
        this.keys = keys;
    }

    public CompletionStage<IntSet> invokeAsync(ComponentRegistry registry) {
        int numberOfKeys = this.keys.size();
        IntSet toKeepIndexes = IntSets.mutableEmptySet((int)numberOfKeys);
        LocalizedCacheTopology topology = registry.getDistributionManager().getCacheTopology();
        IracManager iracManager = registry.getIracManager().running();
        for (int index = 0; index < numberOfKeys; ++index) {
            Object key = this.keys.get(index);
            if (topology.getDistribution(key).isPrimary() && !iracManager.containsKey(key)) continue;
            toKeepIndexes.set(index);
        }
        return CompletableFuture.completedFuture(toKeepIndexes);
    }

    @Override
    public byte getCommandId() {
        return 38;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    @Override
    public String toString() {
        return "IracSiteTombstoneCheckCommand{cacheName=" + String.valueOf(this.cacheName) + ", keys=" + this.keys.stream().map(Util::toStr).collect(Collectors.joining(",")) + "}";
    }
}

