/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JacksonUtil {
    private static final String INPUT_MISMATCH_ERROR_MESSAGE = "Input data does not match expected form";

    private JacksonUtil() {
    }

    @NotNull
    public static JsonNode readTree(@NotNull ObjectMapper objectMapper, @NotNull byte[] bytes) {
        AssertUtil.notNull(objectMapper, "objectMapper must not be null");
        AssertUtil.notNull(bytes, "bytes must not be null");
        try {
            return objectMapper.readTree(bytes);
        }
        catch (JsonParseException | MismatchedInputException e) {
            throw new DataConversionException(INPUT_MISMATCH_ERROR_MESSAGE, e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    public static byte[] binaryValue(@Nullable JsonNode jsonNode) {
        try {
            return jsonNode == null ? null : jsonNode.binaryValue();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

