# (c) Copyright 2014-2015. CodeWeavers, Inc.

import os
import struct

from gi.repository import Gdk
from gi.repository import Gtk

import cxguitools
import cxutils
import distversion

from cxutils import cxgettext as _

def window_manager_name():
    return Gdk.Screen.get_default().get_window_manager_name()

def _fetch_command_output(command):
    lines = []
    retcode, out, err = cxutils.run(os.path.join(cxutils.CX_ROOT, "bin", command), stdout=cxutils.GRAB, stderr=cxutils.GRAB)
    lines.append("\n%s output:" % command)
    lines.append(out.rstrip('\n'))
    if err:
        lines.append("%s err:" % command)
        lines.append(err.rstrip('\n'))
    if retcode:
        lines.append("%s returned %s" % (command, retcode))
    return lines

def system_info_string():
    lines = []

    lines.append("%s %s" % (distversion.PRODUCT_NAME, distversion.PUBLIC_VERSION))

    lines.append("Install location: %s" % cxutils.CX_ROOT)

    lines.append("%s-bit OS" % (struct.calcsize("P") * 8))

    lines.append("Desktop session: %s" % os.environ.get("DESKTOP_SESSION", ""))

    try:
        lines.append("Window manager: %s" % window_manager_name())
    except: # pylint: disable=W0702
        pass

    # locale information
    lang = os.environ.get("LANG", "")
    lines.append("Locale: %s" % lang)
    for var in ('LC_ADDRESS', 'LC_COLLATE', 'LC_CTYPE', 'LC_IDENTIFICATION',
                'LC_MONETARY', 'LC_MESSAGES', 'LC_MEASUREMENT', 'LC_NAME',
                'LC_NUMERIC', 'LC_PAPER', 'LC_TELEPHONE', 'LC_TIME', 'LC_ALL'):
        if var in os.environ and os.environ[var] != lang:
            lines.append("%s: %s" % (var, os.environ[var]))

    # distro information
    try:
        f = open("/etc/os-release", "r")
        try:
            contents = f.read()
        finally:
            f.close()
        lines.append("\nContents of /etc/os-release:")
        lines.append(contents.rstrip('\n'))
    except: # pylint: disable=W0702
        try:
            f = open("/etc/lsb-release", "r")
            try:
                contents = f.read()
            finally:
                f.close()
            lines.append("\nContents of /etc/lsb-release:")
            lines.append(contents.rstrip('\n'))
        except: # pylint: disable=W0702
            lines.append("Failed reading /etc/os-release and /etc/lsb-release")

    lines += _fetch_command_output("cxdiag")

    lines += _fetch_command_output("cxdiag64")

    return '\n'.join(lines)

class TextDialog(object):
    def __init__(self, title, contents):
        self.contents = contents

        self.xml = Gtk.Builder()
        self.xml.set_translation_domain("crossover")
        self.xml.add_from_file(cxguitools.get_ui_path("textdialog"))
        self.xml.connect_signals(self)

        self.xml.get_object("TextDialog").set_title(title)

        self.xml.get_object("TextContents").get_buffer().set_text(self.contents)

    def quit_requested(self, *_args):
        self.xml.get_object("TextDialog").destroy()
        cxguitools.toplevel_quit()

    def copy_clicked(self, _caller):
        clipboard = Gtk.Clipboard.get_default(Gdk.Display.get_default())
        clipboard.set_text(self.contents, -1)
        clipboard.store()

def SystemInfoDialog():
    return TextDialog(_("System Information"), system_info_string())

def LicenseDialog():
    try:
        f = open(os.path.join(cxutils.CX_ROOT, 'license.txt'), 'r')
        try:
            license_txt = f.read()
        finally:
            f.close()
    except:
        # debian
        import gzip
        f = gzip.GzipFile(os.path.join(cxutils.CX_ROOT, 'doc', 'license.txt.gz'), 'r')
        try:
            license_txt = cxutils.string_to_str(f.read())
        finally:
            f.close()

    return TextDialog(_("CrossOver License"), license_txt)
