#!/bin/sh
#
# gen-control.sh
# Copyright 2024 - abc-nix (antiX Linux)
#
# Script to generate control file from control.in template

# Check if required arguments are provided
if [ "$#" -ne 4 ]; then
    echo "gen-control.sh - Usage: $0 <debarch> <maintainer> <version> <build-debug>"
    exit 1
fi

# Assign input arguments to variables
DEBARCH="$1"
MAINTAINER="$2"
VERSION="$3"
BUILD_DEBUG="$4"

# Check if control.in file exists
CONTROL_IN="debian/control.in"
if [ ! -f "$CONTROL_IN" ]; then
    echo "Error: $CONTROL_IN file not found!"
    exit 1
fi

# Generate control file
CONTROL_OUT="debian/control"
echo '# This file is autogenerated. DO NOT EDIT' > "$CONTROL_OUT"
sed -e "s/@DEBARCH@/$DEBARCH/g" \
    -e "s/@MAINTAINER@/$MAINTAINER/g" \
    -e "s/@VERSION@/$VERSION/g" \
    "$CONTROL_IN" >> "$CONTROL_OUT"

# Generate debug package information only if asked for
CONTROL_DEBUG="debian/control.debug"
if [ "$BUILD_DEBUG" -eq 1 ] || [ "$BUILD_DEBUG" = "true" ]; then
    if [ -f "$CONTROL_DEBUG" ]; then
        sed -e "s/@DEBARCH@/$DEBARCH/g" \
            -e "s/@VERSION@/$VERSION/g" \
            "$CONTROL_DEBUG" >> "$CONTROL_OUT"
    fi
fi

echo "Generated $CONTROL_OUT with DEBARCH=$DEBARCH, MAINTAINER=$MAINTAINER, VERSION=$VERSION"
