/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.menu.MenuUtilities;

public class SubstanceSeparatorUI
extends BasicSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSeparatorUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        try {
            Container parent = c.getParent();
            if (!(parent instanceof JPopupMenu)) {
                SubstanceTheme theme = SubstanceLookAndFeel.getTheme();
                boolean isDark = SubstanceCoreUtilities.isThemeDark(theme.getActiveTheme());
                ColorScheme colorScheme = isDark ? theme.getActiveTheme().getColorScheme() : theme.getDefaultTheme().getColorScheme();
                SubstanceCoreUtilities.paintSeparator(graphics, colorScheme, isDark, c.getWidth(), c.getHeight(), ((JSeparator)c).getOrientation());
                return;
            }
            int xOffset = MenuUtilities.getTextOffset((Graphics)graphics, parent);
            Dimension s = c.getSize();
            if (parent.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceCoreUtilities.getActiveScheme(parent);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, leftColor, xOffset, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite((Component)parent, 0.7f));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, xOffset - 2, c.getHeight());
                }
                graphics.setComposite(TransitionLayout.getAlphaComposite(parent));
                graphics.setColor(c.getForeground());
                graphics.drawLine(xOffset, 0, s.width, 0);
                graphics.setColor(c.getBackground());
                graphics.drawLine(xOffset, 1, s.width, 1);
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    ColorScheme scheme = SubstanceCoreUtilities.getActiveScheme(parent);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    GradientPaint gp = new GradientPaint(s.width - xOffset, 0.0f, leftColor, s.width, 0.0f, rightColor);
                    graphics.setComposite(TransitionLayout.getAlphaComposite((Component)parent, 0.7f));
                    graphics.setPaint(gp);
                    graphics.fillRect(s.width - xOffset - 2, 0, s.width, c.getHeight());
                }
                graphics.setComposite(TransitionLayout.getAlphaComposite(parent));
                graphics.setColor(c.getForeground());
                graphics.drawLine(0, 0, s.width - xOffset - 4, 0);
                graphics.setColor(c.getBackground());
                graphics.drawLine(0, 1, s.width - xOffset - 4, 1);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        if (((JSeparator)c).getOrientation() == 1) {
            return new Dimension(2, 0);
        }
        return new Dimension(0, 2);
    }
}

