/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.list;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.list.AbstractComponentDecorator;
import org.jvnet.lafwidget.list.MutableListModel;
import org.jvnet.lafwidget.utils.FadeTracker;

public class SmoothListDrop {
    public static final FadeTracker.FadeKind SMOOTH_LIST_DROP_FADE_KIND = new FadeTracker.FadeKind("lafwidget.internal.smoothListDrop");

    public static void main(String[] args) {
        JFrame f = new JFrame("Smooth List Drop");
        f.setDefaultCloseOperation(3);
        final MyListModel listModel = new MyListModel();
        final JList list = new JList(listModel);
        DropSmoother smoother = new DropSmoother(list){

            protected void move(int fromIndex, int toIndex) {
                listModel.move(fromIndex, toIndex);
                list.revalidate();
                list.repaint();
            }

            protected void init(int index) {
            }
        };
        Listener listener = new Listener(smoother);
        list.addMouseListener(listener);
        list.addMouseMotionListener(listener);
        f.getContentPane().add(new JScrollPane(list));
        f.pack();
        f.setVisible(true);
    }

    public static class MyListModel
    extends AbstractListModel
    implements MutableListModel {
        private List DATA = new ArrayList();

        public MyListModel() {
            for (int i = 0; i < 3000; ++i) {
                this.DATA.add("item " + i);
            }
        }

        public int getSize() {
            return this.DATA.size();
        }

        public Object getElementAt(int index) {
            return this.DATA.get(index);
        }

        public void insert(int index, Object value) {
            this.DATA.add(index, value);
        }

        public void remove(int index) {
            this.DATA.remove(index);
        }

        public void move(int fromIndex, int toIndex) {
            Object value = this.DATA.remove(fromIndex);
            this.DATA.add(toIndex, value);
        }
    }

    static class Listener
    extends MouseAdapter
    implements MouseMotionListener {
        private DropSmoother smoother;
        private boolean dragActive;
        private Point origin;

        public Listener(DropSmoother smoother) {
            this.smoother = smoother;
        }

        private boolean sufficientMove(Point where) {
            int dy;
            int dx = Math.abs(this.origin.x - where.x);
            return dx * dx + (dy = Math.abs(this.origin.y - where.y)) * dy > 25;
        }

        public void mousePressed(MouseEvent e) {
            this.origin = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.dragActive) {
                this.smoother.endDrag(e.getPoint());
                this.dragActive = false;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.dragActive && this.sufficientMove(e.getPoint())) {
                this.smoother.startDrag(this.origin);
                this.dragActive = true;
            }
            if (this.dragActive) {
                this.smoother.setInsertionLocation(e.getPoint());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.dragActive) {
                this.smoother.setInsertionIndex(-1);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (this.dragActive) {
                this.smoother.setInsertionLocation(e.getPoint());
            }
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void stop() {
            this.smoother.stop();
        }
    }

    static abstract class DropSmoother
    extends AbstractComponentDecorator {
        private long fadeInstanceId;
        private int insertionIndex = -1;
        private int draggedIndex = -1;
        private JList list;
        private Map<Integer, Rectangle> bounds = new TreeMap<Integer, Rectangle>();
        private GhostedDragImage dragImage;
        private Point origin;

        public DropSmoother(JList list) {
            super(list);
            this.list = list;
            this.fadeInstanceId = FadeTracker.getInstance().trackFadeLooping(SMOOTH_LIST_DROP_FADE_KIND, LafWidgetUtilities.getAnimationKind(list), list, null, false, new FadeTracker.FadeTrackerCallback(){
                double prevFadeCycle = 0.0;

                public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                    DropSmoother dropSmoother = DropSmoother.this;
                    synchronized (dropSmoother) {
                        if (DropSmoother.this.reposition()) {
                            DropSmoother.this.repaint();
                        }
                        this.prevFadeCycle = fadeCycle10;
                    }
                }
            }, false);
        }

        public void stop() {
            FadeTracker.getInstance().cancelFadeInstance(this.fadeInstanceId);
        }

        protected Object getPlaceholder() {
            return "";
        }

        protected abstract void move(int var1, int var2);

        protected abstract void init(int var1);

        protected void drop(Transferable t, int index) {
        }

        private void initialize(Point where) {
            this.draggedIndex = -1;
            this.insertionIndex = -1;
            this.origin = where;
            int size = this.list.getModel().getSize();
            this.bounds.clear();
            for (int i = 0; i < size; ++i) {
                this.bounds.put(i, this.getCellBoundsAfterInsertion(i));
            }
        }

        public synchronized void startDragOver(Point where) {
            this.initialize(where);
            this.insertionIndex = this.getIndex(where, false);
        }

        public synchronized void endDragOver(Point where, Transferable t) {
            int idx = this.getIndex(where, false);
            if (idx != -1) {
                this.drop(t, idx);
            }
        }

        public synchronized void startDrag(Point where) {
            this.initialize(where);
            this.draggedIndex = this.insertionIndex = this.getIndex(where, true);
            this.list.setSelectedIndex(this.draggedIndex);
            this.dragImage = new GhostedDragImage(this.draggedIndex, this.origin);
            this.init(this.draggedIndex);
        }

        public synchronized void endDrag(Point where) {
            int toIndex = this.getIndex(where, true);
            int fromIndex = this.draggedIndex;
            this.dragImage.dispose();
            this.dragImage = null;
            this.insertionIndex = -1;
            this.draggedIndex = -1;
            if (toIndex != -1 && toIndex != fromIndex) {
                TreeMap<Integer, Rectangle> newBounds = new TreeMap<Integer, Rectangle>();
                newBounds.put(toIndex, this.bounds.get(new Integer(fromIndex)));
                if (fromIndex < toIndex) {
                    for (int i = fromIndex + 1; i <= toIndex; ++i) {
                        newBounds.put(i - 1, this.bounds.get(i));
                    }
                } else {
                    for (int i = toIndex; i < fromIndex; ++i) {
                        newBounds.put(i + 1, this.bounds.get(i));
                    }
                }
                this.bounds.putAll(newBounds);
                this.move(fromIndex, toIndex);
            }
        }

        private boolean reposition() {
            boolean changed = false;
            for (Integer x : this.bounds.keySet()) {
                Rectangle current = this.getCurrentCellBounds(x);
                Rectangle end = this.getCellBoundsAfterInsertion(x);
                if (current.x == end.x && current.y == end.y) continue;
                int xdelta = (end.x - current.x) / 2;
                int ydelta = (end.y - current.y) / 2;
                current.x = xdelta == 0 ? end.x : (current.x += xdelta);
                current.y = ydelta == 0 ? end.y : (current.y += ydelta);
                this.bounds.put(x, current);
                changed = true;
            }
            return changed;
        }

        private int getIndex(Point where, boolean restrict) {
            int idx = this.list.locationToIndex(where);
            if (!restrict) {
                int size = this.list.getModel().getSize();
                Rectangle last = this.list.getCellBounds(size - 1, size - 1);
                if (idx == size - 1 && where.y > last.y + last.height) {
                    idx = size;
                }
            }
            return idx;
        }

        public synchronized void setInsertionLocation(Point where) {
            this.getPainter().requestFocus();
            this.list.clearSelection();
            this.setInsertionIndex(this.getIndex(where, this.draggedIndex != -1));
            this.dragImage.setLocation(where);
        }

        public synchronized void setInsertionIndex(int idx) {
            if (idx != this.insertionIndex) {
                this.insertionIndex = idx;
                this.repaint();
            }
        }

        private Rectangle getCellBoundsAfterInsertion(int index) {
            Rectangle r = this.list.getCellBounds(index, index);
            if (this.draggedIndex != -1) {
                if (index > this.draggedIndex) {
                    if (index <= this.insertionIndex) {
                        Rectangle r2 = this.list.getCellBounds(this.draggedIndex, this.draggedIndex);
                        r.y -= r2.height;
                    }
                } else if (index < this.draggedIndex) {
                    if (index >= this.insertionIndex) {
                        Rectangle r2 = this.list.getCellBounds(this.draggedIndex, this.draggedIndex);
                        r.y += r2.height;
                    }
                } else {
                    Rectangle r2 = this.list.getCellBounds(this.insertionIndex, this.insertionIndex);
                    r.y = r2.y;
                }
            } else if (this.insertionIndex != -1 && index > this.insertionIndex) {
                ListCellRenderer<Object> rnd = this.list.getCellRenderer();
                Component c = rnd.getListCellRendererComponent(this.list, this.getPlaceholder(), this.insertionIndex, false, false);
                r.y += c.getHeight();
            }
            return r;
        }

        private Rectangle getCurrentCellBounds(int cellIndex) {
            Rectangle r = this.getCellBoundsAfterInsertion(cellIndex);
            Rectangle r2 = this.bounds.get(cellIndex);
            if (r2 != null) {
                r.x = r2.x;
                r.y = r2.y;
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void paint(Graphics g) {
            boolean db = this.list.isDoubleBuffered();
            this.list.setDoubleBuffered(false);
            try {
                Rectangle b = this.getDecorationBounds();
                g.setColor(this.list.getBackground());
                g.fillRect(b.x, b.y, b.width, b.height);
                for (int i = 0; i < this.list.getModel().getSize(); ++i) {
                    if (i == this.draggedIndex) continue;
                    Rectangle r = this.getCurrentCellBounds(i);
                    Graphics g2 = g.create(r.x, r.y, r.width, r.height);
                    Rectangle r2 = this.list.getCellBounds(i, i);
                    ((Graphics2D)g2).translate(0, -r2.y);
                    this.list.paint(g2);
                }
            }
            finally {
                this.list.setDoubleBuffered(db);
            }
        }

        private final class GhostedDragImage
        extends AbstractComponentDecorator {
            private int index;
            private Point location;
            private Point offset;

            public GhostedDragImage(int cellIndex, Point origin) {
                super(DropSmoother.this.list);
                this.index = cellIndex;
                Rectangle b = DropSmoother.this.list.getCellBounds(this.index, this.index);
                this.location = origin;
                this.offset = new Point(0, origin.y - b.y);
            }

            public void setLocation(Point where) {
                this.location = where;
                this.repaint();
            }

            public void paint(Graphics g) {
                Rectangle b = DropSmoother.this.list.getCellBounds(this.index, this.index);
                Point origin = new Point(0, this.location.y - this.offset.y);
                origin.y = Math.max(0, origin.y);
                origin.y = Math.min(origin.y, DropSmoother.this.list.getHeight() - b.height);
                g = g.create(origin.x, origin.y, b.width, b.height);
                ((Graphics2D)g).translate(-b.x, -b.y);
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.5f));
                DropSmoother.this.list.paint(g);
            }
        }
    }
}

