#ifndef _FCNTL_H
#define _FCNTL_H

#include <addons.h>
#include <system/types.h>
#include <types/types.h>
#include <fcnsig/fcntl.h>

#ifndef FNDELAY
#define FNDELAY	O_NDELAY
#endif

__BEGIN_DECLS

extern int creat __P ((__const char * __filename, mode_t __mode));

#ifdef  __OPTIMIZE__
#define creat(file, m)  __open((file), O_WRONLY|O_CREAT|O_TRUNC, (m))
#endif 

extern int fcntl __P ((int __fildes,int __cmd, ...));
extern int __fcntl __P ((int __fildes,int __cmd, ...));

extern int open __P ((__const char * __filename, int __flags, ...));
extern int __open __P ((__const char * __filename, int __flags, ...));

#if defined (__USE_MISC) && !defined (F_LOCK)

#define F_ULOCK 0	
#define F_LOCK  1	
#define F_TLOCK 2	
#define F_TEST  3	

extern int lockf __P ((int __fd, int __cmd, __off_t __len));
#endif

__END_DECLS

#endif
