#ifndef _FSTREAM_H
#define _FSTREAM_H
#ifdef __GNUG__
#pragma interface
#endif
#include <iostream.h>

 class ifstream : public fstreambase, public istream {
   public:
    ifstream() : fstreambase() { }
    ifstream(int fd) : fstreambase(fd) { }
    ifstream(int fd, char *p, int l) : fstreambase(fd, p, l) { } 
    ifstream(const char *name, int mode=ios::in, int prot=0664)
    : fstreambase(name, mode, prot) { }
    void open(const char *name, int mode=ios::in, int prot=0664)
    { fstreambase::open(name, mode, prot); }
 };

 class ofstream : public fstreambase, public ostream {
   public:
    ofstream() : fstreambase() { }
    ofstream(int fd) : fstreambase(fd) { }
    ofstream(int fd, char *p, int l) : fstreambase(fd, p, l) { }
    ofstream(const char *name, int mode=ios::out, int prot=0664)
    : fstreambase(name, mode, prot) { }
    void open(const char *name, int mode=ios::out, int prot=0664)
	{ fstreambase::open(name, mode, prot); }
 };

 class fstream : public fstreambase, public iostream {
   public:
    fstream() : fstreambase() { }
    fstream(int fd) : fstreambase(fd) { }
    fstream(const char *name, int mode, int prot=0664)
    : fstreambase(name, mode, prot) { }
    fstream(int fd, char *p, int l) : fstreambase(fd, p, l) { }
    void open(const char *name, int mode, int prot=0664)
    { fstreambase::open(name, mode, prot); }
 };
#endif 
