#ifndef G__IOSTREAM_H

#if !defined(G__IOSTREAM_H) && !defined(__cplusplus)
#define G__IOSTREAM_H

#pragma INTERPRETER level0

#include <stdio.h>

typedef long streamoff;
typedef long streampos;
class io_state;
class streambuf;
class fstreambase;
enum seek_dir{ };
class ios {
      public:
	static int in ;
	static int out ;
	static int app ;
	static int ate ;
	static int goodbit ;
	static int badbit ;
	static int failbit ;
	static int eofbit ;
};

class ostream {
	FILE *fout;
      public:
	ostream(FILE *setfout) { fout=setfout; }
	ostream(char *fname) ;
	~ostream() ;
	void close() { if(fout) fclose(fout); fout=NULL;}
	void flush() { if(fout) fflush(fout); }
	FILE *fp() { return(fout); }

	ostream& operator <<(char c);
	ostream& operator <<(char *s);
	ostream& operator <<(long i);
	ostream& operator <<(unsigned long i);
	ostream& operator <<(double d);
	ostream& operator <<(void *p);
};

ostream::~ostream()
{
	if(fout!=stderr && fout!=stdout && fout!=NULL) {
		fclose(fout);
	}
}

ostream::ostream(char *fname)
{
	fout = fopen(fname,"w");
	if(fout==NULL) {
		fprintf(stderr,"%s can not open\n",fname);
	}
}

ostream& ostream::operator <<(char c)
{
	fprintf(fout,"%c",c);
	return(*this);
}

ostream& ostream::operator <<(char *s)
{
	fprintf(fout,"%s",s);
	return(*this);
}

ostream& ostream::operator <<(long i)
{
	fprintf(fout,"%d",i);
	return(*this);
}

ostream& ostream::operator <<(unsigned long i)
{
	fprintf(fout,"%u",i);
	return(*this);
}

ostream& ostream::operator <<(double d)
{
	fprintf(fout,"%g",d);
	return(*this);
}

ostream& ostream::operator <<(void *p)
{
	printf("0x%x",p);
	return(*this);
}

ostream cout=ostream(stdout);
ostream cerr=ostream(stderr);

class istream {
	FILE *fin;
	ostream *tie;
      public:
	istream(FILE *setfin) { fin = setfin; tie=(ostream*)NULL; }
	istream(char *fname);
	~istream();
	void close() { if(fin) fclose(fin); fin=NULL;}
	ostream& tie(ostream& cx); 
	FILE *fp() { return(fin); }

	istream& operator >>(char& c);
	istream& operator >>(char *s);
	istream& operator >>(short& s);
	istream& operator >>(int& i);
	istream& operator >>(long& i);
	istream& operator >>(unsigned char& c);
	istream& operator >>(unsigned short& s);
	istream& operator >>(unsigned int& i);
	istream& operator >>(unsigned long& i);
	istream& operator >>(double& d);
	istream& operator >>(float& d);
};

istream::~istream()
{
	if(fin!=stdin && fin!=NULL) {
		fclose(fin);
	}
}

istream::istream(char *fname)
{
	fin = fopen(fname,"r");
	if(fin==NULL) {
		fprintf(stderr,"%s can not open\n",fname);
	}
	tie=(ostream*)NULL;
}


ostream& istream::tie(ostream& cx) 

{ 
	ostream *tmp; 
	tmp=tie; 
	tie = &cx; 
	return(*tmp);
}

istream& istream::operator >>(char& c)
{
	if(tie) tie->flush();
	c=fgetc(fin);
	return(*this);
}

istream& istream::operator >>(char *s)
{
	if(tie) tie->flush();
	fscanf(fin,"%s",s);
	return(*this);
}

istream& istream::operator >>(short& s)
{
	if(tie) tie->flush();
	fscanf(fin,"%hd",&s);
	return(*this);
}

istream& istream::operator >>(int& i)
{
	if(tie) tie->flush();
	fscanf(fin,"%d",&i);
	return(*this);
}

istream& istream::operator >>(long& i)
{
	if(tie) tie->flush();
	fscanf(fin,"%ld",&i);
	return(*this);
}

istream& istream::operator >>(unsigned char& c)
{
	int i;
	if(tie) tie->flush();
	fscanf(fin,"%u",&i);
	c = i;
	return(*this);
}
istream& istream::operator >>(unsigned short& s)
{
	if(tie) tie->flush();
	fscanf(fin,"%hu",&s);
	return(*this);
}
istream& istream::operator >>(unsigned int& i)
{
	if(tie) tie->flush();
	fscanf(fin,"%u",&i);
	return(*this);
}
istream& istream::operator >>(unsigned long& i)
{
	if(tie) tie->flush();
	fscanf(fin,"%lu",&i);
	return(*this);
}

istream& istream::operator >>(float& f)
{
	if(tie) tie->flush();
	fscanf(fin,"%g",&f);
	return(*this);
}

istream& istream::operator >>(double& d)
{
	if(tie) tie->flush();
	fscanf(fin,"%lg",&d);
	return(*this);
}

istream cin=istream(stdin);

class iostream : public istream , public ostream {
	iostream(FILE *setfin) : istream(setfin), ostream(setfin) { }
	iostream(char *fname) : istream(fname), ostream(fname) { }
};

class fstream;

class ofstream : public ostream {
};

class ifstream : public istream {
};

class iofstream : public iostream {
};


ostream& endl(ostream& i) {i<<'\n';return(i);}
ostream& ends(ostream& i) {fflush(i,fout);return(i);}
ostream& flush(ostream& i) {fflush(i.fout);return(i);}
istream& ws(istream& i) {
  fprintf(stderr,"ERROR(231)\n");
  return(i);
}
istream& WS(istream& i) {
  fprintf(stderr,"ERROR(231)\n");
  return(i);
}

#endif 

class G__CINT_ENDL { int dmy; } endl;
ostream& operator<<(ostream& ostr,G__CINT_ENDL& i) {return(endl(ostr));}

class G__CINT_ENDS { int dmy; } ends;
ostream& operator<<(ostream& ostr,G__CINT_ENDS& i) {return(ends(ostr));}

class G__CINT_FLUSH { int dmy; } flush;
ostream& operator<<(ostream& ostr,G__CINT_FLUSH& i) {return(flush(ostr));}

class G__CINT_ws { int dmy; } ws;
istream& operator>>(istream& istr,G__CINT_ws& i) {return(ws(istr));}

class G__CINT_WS { int dmy; } WS;
istream& operator>>(istream& istr,G__CINT_WS& i) {return(WS(istr));}

class G__CINT_NOSUPPORT { int dmy; } dec,hex,oct;

ostream& operator<<(ostream& ostr,G__CINT_NOSUPPORT& i) {
  fprintf(stderr,"ERROR(231)\n");
  return(ostr);
}
istream& operator<<(istream& istr,G__CINT_NOSUPPORT& i) {
  fprintf(stderr,"ERROR(231)\n");
  return(istr);
}


#endif
