#ifndef _IO_STDIO_H
#define _IO_STDIO_H

#include <cc++config.h>
#define _IO_pos_t _G_fpos_t 
#define _IO_fpos_t _G_fpos_t
#define _IO_size_t _G_size_t
#define _IO_ssize_t _G_ssize_t
#define _IO_off_t _G_off_t
#define _IO_pid_t _G_pid_t
#define _IO_uid_t _G_uid_t
#define _IO_HAVE_SYS_WAIT _G_HAVE_SYS_WAIT
#define _IO_HAVE_ST_BLKSIZE _G_HAVE_ST_BLKSIZE
#define _IO_BUFSIZ _G_BUFSIZ
#define _IO_va_list _G_va_list

#ifdef _G_NEED_STDARG_H
#define __need___va_list
#include <stdarg.h>
#ifdef __GNUC_VA_LIST
#undef _IO_va_list
#define _IO_va_list __gnuc_va_list
#endif 
#endif

#ifndef __P
#ifdef __STDC__
#define __P(protos) protos
#else
#define __P(protos) ()
#endif
#endif 

#ifndef _PARAMS
#define _PARAMS(protos) __P(protos)
#endif

#ifndef __STDC__
#define const
#endif
#define _IO_USE_DTOA
#define _IO_UNIFIED_JUMPTABLES 1

#if 0
#ifdef _IO_NEED_STDARG_H
#include <stdarg.h>
#endif
#endif

#ifndef EOF
#define EOF (-1)
#endif
#ifndef NULL
#if !defined(__cplusplus) || defined(__GNUC__)
#define NULL ((void*)0)
#else
#define NULL (0)
#endif
#endif

#define _IOS_INPUT	1
#define _IOS_OUTPUT	2
#define _IOS_ATEND	4
#define _IOS_APPEND	8
#define _IOS_TRUNC	16
#define _IOS_NOCREATE	32
#define _IOS_NOREPLACE	64
#define _IOS_BIN	128

#define _IO_MAGIC 0xFBAD0000 
#define _OLD_STDIO_MAGIC 0xFABC0000 
#define _IO_MAGIC_MASK 0xFFFF0000
#define _IO_USER_BUF 1 
#define _IO_UNBUFFERED 2
#define _IO_NO_READS 4 
#define _IO_NO_WRITES 8 
#define _IO_EOF_SEEN 0x10
#define _IO_ERR_SEEN 0x20
#define _IO_DELETE_DONT_CLOSE 0x40 
#define _IO_LINKED 0x80 
#define _IO_IN_BACKUP 0x100
#define _IO_LINE_BUF 0x200
#define _IO_TIED_PUT_GET 0x400 
#define _IO_CURRENTLY_PUTTING 0x800
#define _IO_IS_APPENDING 0x1000
#define _IO_IS_FILEBUF 0x2000

#define _IO_SKIPWS 01
#define _IO_LEFT 02
#define _IO_RIGHT 04
#define _IO_INTERNAL 010
#define _IO_DEC 020
#define _IO_OCT 040
#define _IO_HEX 0100
#define _IO_SHOWBASE 0200
#define _IO_SHOWPOINT 0400
#define _IO_UPPERCASE 01000
#define _IO_SHOWPOS 02000
#define _IO_SCIENTIFIC 04000
#define _IO_FIXED 010000
#define _IO_UNITBUF 020000
#define _IO_STDIO 040000
#define _IO_DONT_CLOSE 0100000

struct _IO_jump_t;  struct _IO_FILE;

struct _IO_marker {
  struct _IO_marker *_next;
  struct _IO_FILE *_sbuf;
  int _pos;
#if 0
    void set_streampos(streampos sp) { _spos = sp; }
    void set_offset(int offset) { _pos = offset; _spos = (streampos)(-2); }
  public:
    streammarker(streambuf *sb);
    ~streammarker();
    int saving() { return  _spos == -2; }
    int delta(streammarker&);
    int delta();
#endif
};

struct _IO_FILE {
  int _flags;	
#define _IO_file_flags _flags

  char* _IO_read_ptr;	
  char* _IO_read_end;	
  char* _IO_read_base;	
  char* _IO_write_base;	
  char* _IO_write_ptr;
  char* _IO_write_end;
  char* _IO_buf_base;
  char* _IO_buf_end;
  char *_IO_save_base;
  char *_IO_backup_base; 
  char *_IO_save_end; 

  struct _IO_marker *_markers;
  
  struct _IO_FILE *_chain;
  
#if  !_IO_UNIFIED_JUMPTABLES
  struct _IO_jump_t *_jumps; 
#endif
  
  int _fileno;
  int _blksize;
  _IO_off_t _offset;
  
#define __HAVE_COLUMN 
  unsigned short _cur_column;
  char _unused;
  char _shortbuf[1];
  
};

#ifndef __cplusplus
typedef struct _IO_FILE _IO_FILE;
#endif

struct _IO_FILE_plus;
extern struct _IO_FILE_plus _IO_stdin_, _IO_stdout_, _IO_stderr_;
#define _IO_stdin ((_IO_FILE*)(&_IO_stdin_))
#define _IO_stdout ((_IO_FILE*)(&_IO_stdout_))
#define _IO_stderr ((_IO_FILE*)(&_IO_stderr_))

#ifdef __cplusplus
extern "C" {
#endif

extern int __underflow __P((_IO_FILE*));
extern int __uflow __P((_IO_FILE*));
extern int __overflow __P((_IO_FILE*, int));

#define _IO_getc(_fp) \
       ((_fp)->_IO_read_ptr >= (_fp)->_IO_read_end ? __uflow(_fp) \
	: *(unsigned char*)(_fp)->_IO_read_ptr++)
#define _IO_peekc(_fp) \
       ((_fp)->_IO_read_ptr >= (_fp)->_IO_read_end \
	  && __underflow(_fp) == EOF ? EOF \
	: *(unsigned char*)(_fp)->_IO_read_ptr)

#define _IO_putc(_ch, _fp) \
   (((_fp)->_IO_write_ptr >= (_fp)->_IO_write_end) \
    ? __overflow(_fp, (unsigned char)(_ch)) \
    : (unsigned char)(*(_fp)->_IO_write_ptr++ = (_ch)))

#define _IO_feof(__fp) (((__fp)->_flags & _IO_EOF_SEEN) != 0)
#define _IO_ferror(__fp) (((__fp)->_flags & _IO_ERR_SEEN) != 0)

#define _IO_PENDING_OUTPUT_COUNT(_fp)	\
	((_fp)->_IO_write_ptr - (_fp)->_IO_write_base)

extern int _IO_vfscanf __P((_IO_FILE*, const char*, _IO_va_list, int*));
extern int _IO_vfprintf __P((_IO_FILE*, const char*, _IO_va_list));
extern _IO_ssize_t _IO_padn __P((_IO_FILE *, int, _IO_ssize_t));
extern _IO_size_t _IO_sgetn __P((_IO_FILE *, void*, _IO_size_t));

extern void _IO_free_backup_area __P((_IO_FILE*));

#ifdef __cplusplus
}
#endif

#endif 
