#if ((defined (__STDC__) && __STDC__) || defined (__cplusplus)) \
	&& !defined(_STDLIB_H)

#define	_STDLIB_H	1
#include <addons.h>

#define	__need_size_t
#define	__need_wchar_t
#define	__need_NULL
#include <stddef.h>

#ifndef NULL
#define NULL ((void *)0)
#endif

#define	__need_Emath
#include <errno.h>

__BEGIN_DECLS

typedef struct
  {
    int quot;	
    int rem;
  } div_t;

typedef struct
  {
    long int quot;
    long int rem;
  } ldiv_t;


#ifndef RAND_MAX
#define	RAND_MAX	2147483647
#endif


#define	EXIT_FAILURE	1
#define	EXIT_SUCCESS	0


#define	MB_CUR_MAX	1


extern double atof __P ((__const char *__nptr));
extern int atoi __P ((__const char *__nptr));
extern long int atol __P ((__const char *__nptr));
#if __GNUC__ >= 2 && defined(__USE_GNU)
extern long long int atoq __P((__const char *__nptr));
#endif

extern float strtof __P ((__const char *__nptr, char **__endptr));
extern double strtod __P ((__const char *__nptr, char **__endptr));
#if __GNUC__ >= 2 && defined(__USE_GNU)
extern __long_double_t strtold __P ((__const char *__nptr, char **__endptr));
#endif
extern long int strtol __P ((__const char *__nptr, char **__endptr,
			     int __base));
extern unsigned long int strtoul __P ((__const char *__nptr,
				       char **__endptr, int __base));
#if __GNUC__ >= 2 && defined(__USE_GNU)
extern long long int strtoq __P((__const char *__nptr, char **__endptr,
				int __base));
extern unsigned long long int strtouq __P((__const char *__nptr,
					char **__endptr, int __base));
#endif


extern double __strtod_internal (__const char *__nptr,
				 char **__endptr, int __group);
extern float __strtof_internal (__const char *__nptr, char **__endptr,
				int __group);
extern __long_double_t __strtold_internal (__const char *__nptr,
					   char **__endptr, int __group);
extern long int __strtol_internal (__const char *__nptr, char **__endptr,
				   int __base, int __group);
extern unsigned long int __strtoul_internal (__const char *__nptr,
					     char **__endptr, int __base,
					     int __group);
#if __GNUC__ >= 2 && defined(__USE_GNU)
extern long long int __strtoq_internal (__const char *__nptr, char **__endptr,
					int __base, int __group);
extern unsigned long long int __strtouq_internal (__const char *__nptr,
						  char **__endptr, int __base,
						  int __group);
#endif

#if defined (__OPTIMIZE__) && __GNUC__ >= 2 && !defined(__STRICT_ANSI__)

extern __inline double strtod (__const char *__nptr, char **__endptr)
{ return __strtod_internal (__nptr, __endptr, 0); }
extern __inline long int strtol (__const char *__nptr,
				 char **__endptr, int __base)
{ return __strtol_internal (__nptr, __endptr, __base, 0); }
extern __inline unsigned long int strtoul (__const char *__nptr,
					   char **__endptr, int __base)
{ return __strtoul_internal (__nptr, __endptr, __base, 0); }

extern __inline float strtof (__const char *__nptr, char **__endptr)
{ return __strtof_internal (__nptr, __endptr, 0); }
extern __inline __long_double_t strtold (__const char *__nptr, char **__endptr)
{ return __strtold_internal (__nptr, __endptr, 0); }

#ifdef __USE_GNU
extern __inline long long int strtoq (__const char *__nptr, char **__endptr,
                                      int __base)
{ return __strtoq_internal (__nptr, __endptr, __base, 0); }
extern __inline unsigned long long int strtouq (__const char *__nptr,
                                            char **__endptr, int __base)
{ return __strtouq_internal (__nptr, __endptr, __base, 0); }
#endif

extern __inline double atof (__const char *__nptr)
{ return strtod(__nptr, (char **) NULL); }
extern __inline int atoi (__const char *__nptr)
{ return (int) strtol (__nptr, (char **) NULL, 10); }
extern __inline long int atol (__const char *__nptr)
{ return strtol (__nptr, (char **) NULL, 10); }
#ifdef __USE_GNU
extern __inline long long int atoq (__const char *__nptr)
{ return strtoq(__nptr, (char **) NULL, 10); }
#endif
#endif 


extern int rand __P ((void));
extern void srand __P ((unsigned int __seed));

extern long int __random __P ((void));
extern void __srandom __P ((unsigned int __seed));

extern __ptr_t __initstate __P ((unsigned int __seed, __ptr_t __statebuf,
				 size_t __statelen));
extern __ptr_t __setstate __P ((__ptr_t __statebuf));

#ifdef	__USE_BSD
extern long int random __P ((void));
extern void srandom __P ((unsigned int __seed));
extern __ptr_t initstate __P ((unsigned int __seed, __ptr_t __statebuf,
			       size_t __statelen));
extern __ptr_t setstate __P ((__ptr_t __statebuf));

#if defined (__OPTIMIZE__) && __GNUC__ >= 2 && !defined(__STRICT_ANSI__)
extern __inline long int random (void)
{ return __random(); }
extern __inline void srandom (unsigned int __seed)
{ __srandom(__seed); }
extern __inline __ptr_t initstate (unsigned int __seed,
				   __ptr_t __statebuf, size_t __statelen)
{ return __initstate (__seed, __statebuf, __statelen); }
extern __inline __ptr_t setstate (__ptr_t __statebuf)
{ return __setstate (__statebuf); }
#endif 
#endif 


extern __ptr_t malloc __P ((size_t __size));
extern __ptr_t realloc __P ((__ptr_t __ptr, size_t __size));
extern __ptr_t calloc __P ((size_t __nmemb, size_t __size));
extern void free __P ((__ptr_t __ptr));

#ifdef	__USE_MISC
extern void cfree __P ((__ptr_t __ptr));
#endif

#if defined(__USE_GNU) || defined(__USE_BSD) || defined(__USE_MISC)
#include <alloca.h>
#endif 

#ifdef	__USE_BSD
extern __ptr_t valloc __P ((size_t __size));
#endif


extern __NORETURN void abort __P ((void));


extern int atexit __P ((void (*__func) (void)));

#ifdef	__USE_MISC
extern int on_exit __P ((void (*__func) (int __status, __ptr_t __arg),
			 __ptr_t __arg));
#endif

extern __NORETURN void exit __P ((int __status));


extern char *getenv __P ((__const char *__name));

#ifdef	__USE_SVID
extern int putenv __P ((__const char *__string));
#endif

#ifdef	__USE_BSD
extern int setenv __P ((__const char *__name, __const char *__value,
			int __replace));
#endif

extern int system __P ((__const char *__command));


#ifndef __COMPAR_FN_T
#define __COMPAR_FN_T
typedef int (*__compar_fn_t) __P ((__const __ptr_t, __const __ptr_t));
#endif

#ifdef	__USE_GNU
typedef __compar_fn_t comparison_fn_t;
#endif

extern __ptr_t bsearch __P ((__const __ptr_t __key, __const __ptr_t __base,
			     size_t __nmemb, size_t __size,
			     __compar_fn_t __compar));

extern void qsort __P ((__ptr_t __base, size_t __nmemb, size_t __size,
			__compar_fn_t __compar));


#ifndef	__CONSTVALUE
#ifdef	__GNUC__
#define	__CONSTVALUE	__const
#else
#define	__CONSTVALUE
#endif
#endif 

extern __CONSTVALUE int abs __P ((int __x));
extern __CONSTVALUE long int labs __P ((long int __x));


extern __CONSTVALUE div_t div __P ((int __numer, int __denom));
extern __CONSTVALUE ldiv_t ldiv __P ((long int __numer, long int __denom));


extern int mblen __P ((__const char *__s, size_t __n));
extern int mbtowc __P ((wchar_t * __pwc, __const char *__s, size_t __n));
extern int wctomb __P ((char *__s, wchar_t __wchar));

#if defined (__OPTIMIZE__) && __GNUC__ >= 2 && !defined(__STRICT_ANSI__)
extern __inline int mblen (__const char *__s, size_t __n)
{ return mbtowc ((wchar_t *) NULL, __s, __n); }
#endif 

extern size_t mbstowcs __P ((wchar_t * __pwcs, __const char *__s, size_t __n));
extern size_t wcstombs __P ((char *__s, __const wchar_t * __pwcs, size_t __n));

#if (defined(MALLOC_0_RETURNS_NULL) || defined(NO_FIX_MALLOC)) \
	&& !defined(__MALLOC_0_RETURNS_NULL)
#define __MALLOC_0_RETURNS_NULL
#endif

#if 0 && !defined(__MALLOC_0_RETURNS_NULL)
static __inline void* __gnu_calloc (size_t __nmemb, size_t __n)
{
  return calloc (__nmemb ? __nmemb : 1, __n ? __n : 1);
}

static __inline void* __gnu_malloc (size_t __n)
{
  return malloc (__n ? __n : 1);
}

#define calloc		__gnu_calloc
#define malloc		__gnu_malloc

#endif

#if defined(__USE_MISC)

extern char **environ;
extern char **__environ;

extern void*	memalign __P((size_t __alignment, size_t __size));

extern char*	ecvt __P((double __value, size_t __ndigit, int *__decpt,
			int *__sign));
extern char*	fcvt __P((double __value, size_t __ndigit, int *__decpt,
			int *__sign));
extern char*	gcvt __P((double __value, size_t __ndigit, char *__buf));

extern double	drand48 __P((void));
extern double	erand48 __P((unsigned short int __xsubi[3]));
extern long int	lrand48 __P((void));
extern long int	nrand48 __P((unsigned short int __xsubi[3]));
extern long int	mrand48 __P((void));
extern long int	jrand48 __P((unsigned short int __xsubi[3]));
extern void	srand48 __P((long int __seedval));
extern unsigned short int
			*seed48 __P((unsigned short int __seed16v[3]));
extern void	lcong48 __P((unsigned short int __param[7]));

extern int	setenv __P((__const char *__name, __const char *__value,
			int __overwrite));
extern void	unsetenv __P((__const char *__name));

struct qelem {
  struct qelem *q_forw;
  struct qelem *q_back;
  char q_data[1];
};

extern void insque __P((struct qelem *__elem, struct qelem *__prev));
extern void remque __P((struct qelem *__elem));

#endif	

__END_DECLS

#endif
