/*#################################################################
# Copyright (c) 1991 AT&T Bell Laboratories, All Rights Reserved   
# Published in ``A C++ Primer''  by Stanley Lippman, Addison-Wesley
#################################################################*/

// general template definition
template <class T> 
T min(T t1, T t2) 
{
    return (t1 < t2 ? t1 : t2); 
}

#include <string.h>
// char* specialization: 
// overrides template definition
char *min(char* s1, char* s2)
{
    return (strcmp(s1,s2) < 0 ? s1 : s2);
}

#include <iostream.h>
main() {
    // template: int min(int,int);
    int i = min(10,5);  

    // specialized char* min(char*,char*);
    char *p = min("hello","world");

    cout << "i: " << i << " p: " << p << endl;
    return 0;
}
