/*#################################################################
# Copyright (c) 1991 AT&T Bell Laboratories, All Rights Reserved   
# Published in ``A C++ Primer''  by Stanley Lippman, Addison-Wesley
#################################################################*/

const notFound = -1; // global scope

int binSearch( int *ia, int sz, int val )
{ // local scope: level #1
     int low = 0;
     int high = sz - 1;

     while ( low <= high )
     { // local scope: level #2
          int mid = (low+high)/2;
          if (val == ia[ mid ]) return mid;
          if (val < ia[ mid ])
              high = mid-1;
          else low = mid+1;
      }   
      return notFound; // local scope: level #1
}  

#include <iostream.h>

int ia[10] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, };
main() {
    cout << binSearch( ia, 10, 7 );
    cout << binSearch( ia, 10, 10 );
}
