/* frog.c Copyright Michael Temari 07/15/96 All Rights Reserved */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/times.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <net/netlib.h>
#include <net/hton.h>
#include <net/gen/netdb.h>
#include <net/gen/socket.h>
#include <net/gen/in.h>
#include <net/gen/inet.h>
#include <net/gen/ip_io.h>
#include <net/gen/ip_hdr.h>
#include <net/gen/icmp.h>
#include <net/gen/icmp_hdr.h>
#include <net/gen/oneCsum.h>

#define	MAX_HOP	30

_PROTOTYPE(void TimeOut, (int sig));
_PROTOTYPE(int ourpacket, (icmp_hdr_t *icmp_hdr, int id, int seq));
_PROTOTYPE(int main, (int argc, char *argv[]));

static unsigned char buffer[8192];

void TimeOut(sig)
int sig;
{
}

/* check here if this packet is a response to one of our packets */
int ourpacket(icmp_hdr, id, seq)
icmp_hdr_t *icmp_hdr;
int id;
int seq;
{
ip_hdr_t *ip_hdr;
char *p;

   if(icmp_hdr->ih_type == ICMP_TYPE_ECHO_REPL)
   	if(icmp_hdr->ih_code == 0 &&
	   icmp_hdr->ih_hun.ihh_idseq.iis_id == id &&
	   icmp_hdr->ih_hun.ihh_idseq.iis_seq == seq)
	   	return(1);
	else
      		return(0);

   if((icmp_hdr->ih_type >=  8 && icmp_hdr->ih_type <= 10) ||
      (icmp_hdr->ih_type >= 13 && icmp_hdr->ih_type <= 16))
   	return(0);

   p = (char *)icmp_hdr;

   p += 8;

   ip_hdr = (ip_hdr_t *)p;

   icmp_hdr = (icmp_hdr_t *)(p + 4 * (ip_hdr->ih_vers_ihl & 0x0f));

   if(icmp_hdr->ih_type == ICMP_TYPE_ECHO_REQ &&
      icmp_hdr->ih_code == 0 &&
      icmp_hdr->ih_hun.ihh_idseq.iis_id == id &&
      icmp_hdr->ih_hun.ihh_idseq.iis_seq == seq)
      	return(1);	/* it's ours */

   return(0);
}

int main(argc, argv)
int argc;
char *argv[];
{
char *p;
struct hostent *hostent;
ipaddr_t hostaddr;
int s;
char *ip_device;
int ip_fd;
nwio_ipopt_t ipopt;
ip_hdr_t *ip_hdr;
icmp_hdr_t *icmp_hdr;
int ttl;
char *extradata;
int extra;
int len;
int ret = -1;
struct tms tms;
clock_t start, stop;
time_t readtimeout;
int ping = 0;

   if(argc != 2) {
   	fprintf(stderr, "Usage: %s hostname\n", argv[0]);
   	return(-1);
   }

   if((hostaddr = inet_addr(argv[1])) == -1)
	if((hostent = gethostbyname(argv[1])) == (struct hostent *)NULL) {
   		fprintf(stderr, "%s: Unknown host %s\n", argv[0], argv[1]);
   		return(-1);
   	} else
   		hostaddr = *(ipaddr_t *) hostent->h_addr;

   if((p = strrchr(argv[0], '/')) == (char *)NULL)
	p = argv[0];
   else
	p++;

   if(strcmp(p, "ping") == 0) ping = 1;

   if(ping)
	printf("Pinging ");
   else
	printf("    Trace Route Frogging to ");

   hostent = gethostbyaddr((char *) &hostaddr, sizeof(ipaddr_t), AF_INET);
   if(hostent != (struct hostent *)NULL)
	printf("%s ", hostent->h_name);
   printf("(%s)\n", inet_ntoa(hostaddr));

   if((ip_device = getenv("IP_DEVICE")) == (char *)NULL)
   	ip_device = IP_DEVICE;

   if((ip_fd = open(ip_device, O_RDWR)) < 0) {
   	fprintf(stderr, "%s: Could not open %s: %s\n",
   		argv[0], ip_device, strerror(errno));
   	return(-1);
   }

   s = ioctl(ip_fd, NWIOGIPOPT, &ipopt);
   if(s < 0) {
  	fprintf(stderr, "%s: Unable to NWIOGIPOPT %s\n",
   		argv[0], strerror(errno));
	return(-1);
   }

   for(ttl = 1; ttl < MAX_HOP; ttl++) {
	ipopt.nwio_flags  = NWIO_NOFLAGS;
	ipopt.nwio_flags |= NWIO_COPY | NWIO_EN_LOC | NWIO_DI_BROAD;
	ipopt.nwio_flags |= NWIO_REMANY | NWIO_HDR_O_SPEC | NWIO_RWDATALL;
	ipopt.nwio_flags |= NWIO_PROTOSPEC;
	ipopt.nwio_proto = IPPROTO_ICMP;
	ipopt.nwio_ttl = ping ? 255 : ttl;

	s = ioctl(ip_fd, NWIOSIPOPT, &ipopt);
	if(s < 0) {
   		fprintf(stderr, "%s: Unable to NWIOSIPOPT %s\n",
   			argv[0], strerror(errno));
		return(-1);
	}

	s = ioctl(ip_fd, NWIOGIPOPT, &ipopt);
	if(s < 0) {
   		fprintf(stderr, "%s: Unable to NWIOGIPOPT %s\n",
   			argv[0], strerror(errno));
		return(-1);
	}

	ip_hdr = (ip_hdr_t *)buffer;
	ip_hdr->ih_dst = hostaddr;
	icmp_hdr = (icmp_hdr_t *)(buffer + sizeof(ip_hdr_t));
	icmp_hdr->ih_type = ICMP_TYPE_ECHO_REQ;
	icmp_hdr->ih_code = 0;
	icmp_hdr->ih_hun.ihh_idseq.iis_id = getpid();
	icmp_hdr->ih_hun.ihh_idseq.iis_seq = ttl;
	icmp_hdr->ih_chksum = 0;
	extradata = "Minix Trace Route Frog By Michael Temari";
	extra = strlen(extradata) + 1;
	sprintf((char *)(icmp_hdr + sizeof(icmp_hdr_t)), extradata);
	icmp_hdr->ih_chksum =
		~oneC_sum(0, (u16_t *)icmp_hdr, sizeof(icmp_hdr_t) + extra);

	len = sizeof(ip_hdr_t) + sizeof(icmp_hdr_t) + extra;

	if(!ping)
		printf("%3d: ", ttl); fflush(stdout);

	start = times(&tms);

	s = write(ip_fd, buffer, len);
	if(s <= 0) {
		printf("write error: %s\n", strerror(errno));
		continue;
	}
	if(s != len) {
		fprintf(stderr, "%s: write only wrote %d instead of %d\n",
			argv[0], s, len);
		return(-1);
	}

	alarm(0);
	signal(SIGALRM, TimeOut);
	alarm(3);

	readtimeout = time((time_t *) NULL) + (time_t) 3;

	while(1) {
		s = read(ip_fd, buffer, sizeof(buffer));
		if(s <= 0) {
			if(errno == EINTR) {
				printf("*\n");
				break;
			}
			perror("read");
			return(-1);
		}
		alarm(0);
		stop = times(&tms);
		ip_hdr = (ip_hdr_t *) buffer;
		icmp_hdr = (icmp_hdr_t *)(buffer + 4 * (ip_hdr->ih_vers_ihl & 0x0f));
		if(ourpacket(icmp_hdr, getpid(), ttl)) break;
		/* wasn't our packet reset timeout for read */
		if(time((time_t *)NULL) > readtimeout) {
			printf("*\n");
			s = -1;
			break;
		}
		signal(SIGALRM, TimeOut);
		alarm(3);
	}
	if(s <= 0) continue;
	printf("%5lu ms ", ((clock_t) 1000 * (stop - start)) / CLOCKS_PER_SEC);
	hostent = gethostbyaddr((char *) &ip_hdr->ih_src, sizeof(ipaddr_t), AF_INET);
	if(hostent != (struct hostent *)NULL)
		printf("%s ", hostent->h_name);
	printf("(%s) ", inet_ntoa(ip_hdr->ih_src));
	switch(icmp_hdr->ih_type) {
		case ICMP_TYPE_ECHO_REPL:
			printf("Splash\n");
			ret = 0;
			break;
		case ICMP_TYPE_DST_UNRCH:
			switch(icmp_hdr->ih_code) {
				case ICMP_NET_UNRCH:
					printf("Net Unreachable\n");
					break;
				case ICMP_HOST_UNRCH:
					printf("Host Unreachable\n");
					break;
				default:
					printf("Destination Unreachable code %u\n", icmp_hdr->ih_code);
			}
			break;
		case ICMP_TYPE_TIME_EXCEEDED:
			if(icmp_hdr->ih_code != ICMP_TTL_EXC) {
				printf("ICMP type %u code %u\n",
					icmp_hdr->ih_type, icmp_hdr->ih_code);
				break;
			}
			printf("%s\n", (ttl & 1) ? "Hip" : "Hop");
			continue;
		default:
			printf("ICMP type %u code %u\n",
				icmp_hdr->ih_type, icmp_hdr->ih_code);
	}
	break;
   }

   close(ip_fd);

   return(ret);
}
