/* config.h
 *
 * This file is part of httpd.
 *
 * 02/26/96 			Michael Temari, <temari@ix.netcom.com>
 * 07/07/96 Initial Release	Michael Temari, <temari@ix.netcom.com>
 *
 */

struct authuser {
	char *user;
	struct authuser *next;
};

struct auth {
	char *name;
	char *desc;
	int urlaccess;
	char *passwdfile;
	struct authuser *users;
	struct auth *next;
};

struct msufx {
	char *suffix;
	struct mtype *mtype;
	struct msufx *snext;
	struct msufx *tnext;
};

struct mtype {
	char *mimetype;
	struct msufx *msufx;
	struct mtype *next;
};

struct vpath {
	char *from;
	char *to;
	struct auth *auth;
	int urlaccess;
	struct vpath *next;
};

struct dirsend {
	char *file;
	struct dirsend *next;
};

/* urlaccess bits */

#define	URLA_READ	1
#define	URLA_WRITE	2
#define	URLA_EXEC	4

#define	HTTPD_CONFIG_FILE	"/etc/httpd.conf"

_PROTOTYPE(int readconfig, (char *cfg_file, int testing));

extern struct mtype *mtype;
extern struct msufx *msufx;
extern struct vpath *vpath;
extern struct dirsend *dirsend;
extern struct auth *auth;
extern char *direxec;
extern char *srvrroot;
extern char *LogFile;
extern char *DbgFile;
extern char *User;
extern char *Chroot;
