/* dir2html.c by Michael Temari 3/3/96 */

#include <sys/types.h>
#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

_PROTOTYPE(int main, (int argc, char *argv[]));

int main(argc, argv)
int argc;
char *argv[];
{
DIR *dp;
struct dirent *de;
static char dname[1024];
static char vpath[1024];
char *filename;

   if(argc > 1)
	if(chdir(argv[1])) {
		perror("chdir");
		return(-1);
   	}

   if(getcwd(dname, sizeof(dname)) == NULL) {
	perror("getcwd");
	return(-1);
   }

   if(argc > 2)
	strcpy(vpath, argv[2]);
   else
	strcpy(vpath, dname);

   if(vpath[strlen(vpath)-1] != '/')
	strcat(vpath, "/");

   if((dp = opendir(".")) == NULL) {
	perror("opendir");
	return(-1);
   }

   printf("<HTML><TITLE>Directory of %s</TITLE>\n", vpath);
   printf("<H1>Directory of %s</H1>\n", vpath);
   printf("<HR>\n");

   printf("<H3>\n");

   while(1) {
	errno = 0;
	if((de = readdir(dp)) == NULL) break;
	if(de->d_ino == 0) continue;
	if(de->d_name[0] == 0) continue;
	filename = de->d_name;
	if(!strcmp(filename, ".") || !strcmp(filename, "..")) continue;
	printf("<A HREF=\"%s%s\">%s</A><BR>\n", vpath, filename, filename);
   }
   if(errno != 0) perror("readdir");
   closedir(dp);

   printf("</H3>\n");

   printf("<HR>\n");
   printf("<H6>Directory Listing brought to you by dir2html.c!</H6>\n");
   printf("</HTML>\n");

   return(0);
}
