/* httpd.c
 *
 * httpd	A Server implementing the HTTP protocol.
 *
 * usage:	tcpd http httpd &
 *
 * 02/17/96 			Michael Temari, <temari@ix.netcom.com>
 * 07/07/96 Initial Release	Michael Temari, <temari@ix.netcom.com>
 *
 */
#include <sys/types.h>
#include <pwd.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "http.h"
#include "utility.h"
#include "net.h"
#include "config.h"

FILE *stdlog;
FILE *dbglog;

_PROTOTYPE(int main, (int argc, char *argv[]));

struct http_request request;
struct http_reply reply;

int main(argc, argv)
int argc;
char *argv[];
{
char *cfg = (char *)NULL;
struct passwd *pwd;
int arg;
int opt_t;

   arg = 1;

   if(argc > arg)
	if(!strcmp(argv[arg], "-t")) {
		opt_t = 1;
		arg = 2;
	}

   if(argc > arg)
   	cfg = argv[arg];

   if(readconfig(cfg, opt_t)) {
   	fprintf(stderr, "httpd: Error reading configuration file.\n");
   	return(-1);
   }

   if(opt_t)
	return(0);

   /* open log file if it exists */
   if(LogFile != NULL)
	if((stdlog = fopen(LogFile, "r")) != (FILE *)NULL) {
		fclose(stdlog);
		stdlog = fopen(LogFile, "a");
	}

   /* open debug log file if it exists */
   if(DbgFile != NULL)
	if((dbglog = fopen(DbgFile, "r")) != (FILE *)NULL) {
		fclose(dbglog);
		dbglog = fopen(DbgFile, "a");
   }

   GetNetInfo();

   /* if user defined then secure as user given */
   if(User != NULL)
	if((pwd = getpwnam(User)) == (struct passwd *)NULL) {
   		fprintf(stderr, "httpd: unable to find user %s\n", User);
  	 	return(-1);
	}
   if(Chroot != NULL) {
	if(chroot(Chroot)) {
		fprintf(stderr, "httpd: unable to chroot\n");
		return(-1);
	}
	if(chdir("/")) {
   		fprintf(stderr, "httpd: unable to chroot\n");
   		return(-1);
	}
   }
   if(User != NULL)
	if(setgid(pwd->pw_gid) || setuid(pwd->pw_uid)) {
   		fprintf(stderr, "httpd: unable to set user\n");
   		return(-1);
	}

   /* Here is where the tcpd standalone code will go */

   /* GetNetInfo() */

   /* log a connection */
   if(dbglog != (FILE *)NULL) {
	fprintf(dbglog, "CONNECT: %d %s %s\n", getpid(),
		rmthostname, logdate((time_t *)NULL));
	fflush(dbglog);
   }

   /* loop getting processing and replying to requests */
   while(getrequest(&request) == 0) {
	if(processrequest(&request, &reply)) break;
	if(stdlog != (FILE *)NULL) {
		fprintf(stdlog, "%s %s %d %d %s\n",
			logdate((time_t *)NULL), rmthostname,
			request.method, reply.status, request.url);
		fflush(stdlog);
	}
	if(sendreply(&reply, &request)) break;
	if(!reply.keepopen) break;
   }

   return(0);
}
